/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.peeko32213.unusualprehistory.UnusualPrehistory;
import com.peeko32213.unusualprehistory.common.data.EncyclopediaCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncyclopediaJsonManager
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    public static final Logger LOGGER = LogManager.getLogger();
    private final String folderName;
    protected static Map<ResourceLocation, EncyclopediaCodec> encyclopediaEntries = new HashMap<ResourceLocation, EncyclopediaCodec>();
    protected static EncyclopediaCodec rootPage;

    public EncyclopediaJsonManager() {
        this("unusualprehistory/encyclopedia", STANDARD_GSON);
    }

    public static Map<ResourceLocation, EncyclopediaCodec> getEncyclopediaEntries() {
        return encyclopediaEntries;
    }

    public static void setEncyclopediaEntries(Map<ResourceLocation, EncyclopediaCodec> encyclopediaEntries) {
        EncyclopediaJsonManager.encyclopediaEntries = encyclopediaEntries;
    }

    public static EncyclopediaCodec getRootPage() {
        return rootPage;
    }

    public static void setRootPage(EncyclopediaCodec rootPage) {
        EncyclopediaJsonManager.rootPage = rootPage;
    }

    public EncyclopediaJsonManager(String folderName, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap<ResourceLocation, EncyclopediaCodec> encyclopedia = new HashMap<ResourceLocation, EncyclopediaCodec>();
        AtomicReference rootPageR = new AtomicReference();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            EncyclopediaCodec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                EncyclopediaCodec encyclopediaCodec = (EncyclopediaCodec)result.getFirst();
                if (key.equals((Object)UnusualPrehistory.prefix("root"))) {
                    rootPageR.set(encyclopediaCodec);
                } else {
                    encyclopediaCodec.getEntityButtons().forEach(b -> {
                        if (b.getLinkedPage().equals("")) {
                            b.setLinkedPage(String.valueOf(key));
                        }
                    });
                    encyclopediaCodec.getPlantButtons().forEach(b -> {
                        if (b.getLinkedPage().equals("")) {
                            b.setLinkedPage(String.valueOf(key));
                        }
                    });
                    encyclopedia.put(key, encyclopediaCodec);
                }
            }).ifRight(partial -> LOGGER.error("Failed to parse recipe JSON for {} due to: {}", (Object)this.folderName, (Object)partial.message()));
        }
        rootPage = (EncyclopediaCodec)rootPageR.get();
        encyclopediaEntries = encyclopedia;
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)encyclopediaEntries.size());
    }
}

