/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block.entity;

import com.peeko32213.unusualprehistory.common.block.BlockIncubator;
import com.peeko32213.unusualprehistory.common.entity.EntitySmilodon;
import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.baby.EntityBabySmilodon;
import com.peeko32213.unusualprehistory.common.message.SyncItemStackC2SPacket;
import com.peeko32213.unusualprehistory.common.message.SyncItemStackS2CPacket;
import com.peeko32213.unusualprehistory.common.recipe.IncubatorRecipe;
import com.peeko32213.unusualprehistory.core.registry.UPBlockEntities;
import com.peeko32213.unusualprehistory.core.registry.UPMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends BlockEntity
implements ContainerListener {
    private BlockState blockstate;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 1152;
    private List<ItemStack> inv = new ArrayList<ItemStack>();
    private IncubatorBlockEntity blockEntity;
    public int tickCount = 0;
    public static final Logger LOGGER = LogManager.getLogger();
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IncubatorBlockEntity.this.m_6596_();
            if (!((IncubatorBlockEntity)IncubatorBlockEntity.this).f_58857_.f_46443_) {
                UPMessages.sendToClients(new SyncItemStackC2SPacket(this, IncubatorBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);

    public IncubatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)UPBlockEntities.INCUBATOR_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.blockstate = pBlockState;
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> IncubatorBlockEntity.this.progress;
                    case 1 -> IncubatorBlockEntity.this.tickCount;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        IncubatorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        IncubatorBlockEntity.this.tickCount = value;
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
        if (this.f_58857_ != null) {
            this.blockEntity = (IncubatorBlockEntity)this.f_58857_.m_7702_(pPos);
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, IncubatorBlockEntity pBlockEntity) {
        if (!pLevel.f_46443_ && pBlockEntity.inv != null && !pBlockEntity.inv.isEmpty()) {
            UPMessages.sendToClients(new SyncItemStackS2CPacket(pBlockEntity.inv, pPos));
        }
        ++pBlockEntity.tickCount;
        if (IncubatorBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            if (pBlockEntity.progress >= pBlockEntity.maxProgress / 2) {
                pBlockEntity.m_58900_().m_61124_((Property)BlockIncubator.CRACKED, (Comparable)Boolean.valueOf(true));
            }
            IncubatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                IncubatorBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            IncubatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static boolean hasRecipe(IncubatorBlockEntity entity) {
        Level level = entity.f_58857_;
        if (entity.inv == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(entity.inv.size());
        for (int i = 0; i < entity.inv.size(); ++i) {
            inventory.m_6836_(i, entity.inv.get(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)IncubatorRecipe.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent();
    }

    private static void craftItem(IncubatorBlockEntity entity) {
        Level level = entity.f_58857_;
        if (entity.inv == null) {
            return;
        }
        SimpleContainer inventory = new SimpleContainer(entity.inv.size());
        for (int i = 0; i < entity.inv.size(); ++i) {
            inventory.m_6836_(i, entity.inv.get(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)IncubatorRecipe.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent()) {
            entity.inv.clear();
            ResourceLocation toSpawn = ((IncubatorRecipe)match.get()).getOutput();
            if (!level.f_46443_) {
                UPMessages.sendToClients(new SyncItemStackS2CPacket(entity.inv, entity.f_58858_));
                BlockPos pos = entity.f_58858_;
                Direction dir = (Direction)entity.m_58900_().m_61143_((Property)BlockIncubator.FACING);
                pos = pos.m_5484_(dir, 1);
                boolean entitySpawned = IncubatorBlockEntity.spawnEntity((ServerLevel)level, pos, toSpawn, (IncubatorRecipe)match.get());
                if (entitySpawned) {
                    entity.f_58857_.m_46961_(entity.f_58858_, true);
                }
            }
            entity.resetProgress();
        }
    }

    public ItemStack getRenderStack() {
        ItemStack stack = ItemStack.f_41583_;
        if (this.inv == null) {
            return stack;
        }
        if (!this.inv.isEmpty() && !this.inv.get(0).m_41619_()) {
            stack = this.inv.get(0);
        }
        return stack;
    }

    private static boolean spawnEntity(ServerLevel serverLevel, BlockPos pos, ResourceLocation toSpawn, IncubatorRecipe recipe) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(toSpawn);
        LivingEntity livingEntity = (LivingEntity)entityType.m_20615_((Level)serverLevel);
        if (livingEntity == null) {
            LOGGER.error("Invalid entity resourcelocation for {}", (Object)recipe.m_6423_());
            return false;
        }
        livingEntity.m_146884_(Vec3.m_82512_((Vec3i)pos));
        livingEntity.m_20084_(UUID.randomUUID());
        if (livingEntity instanceof IHatchableEntity) {
            IHatchableEntity hatchableEntity = (IHatchableEntity)livingEntity;
            hatchableEntity.determineVariant(serverLevel.f_46441_.m_188503_(100));
        }
        if (livingEntity instanceof Animal) {
            Animal animal = (Animal)livingEntity;
            animal.m_146762_(-24000);
            if (livingEntity instanceof EntitySmilodon) {
                EntitySmilodon smilodon = (EntitySmilodon)livingEntity;
                smilodon.determineVariant(0);
            } else if (livingEntity instanceof EntityBabySmilodon) {
                EntityBabySmilodon smilodon = (EntityBabySmilodon)livingEntity;
                smilodon.determineVariant(0);
            }
            serverLevel.m_7967_((Entity)animal);
        } else {
            serverLevel.m_7967_((Entity)livingEntity);
        }
        return true;
    }

    private boolean getDestroyChance(Level level) {
        return level.f_46441_.m_216339_(0, 100) <= 30;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public static List<ItemStack> getInventory(Level level, BlockPos pos) {
        IncubatorBlockEntity incubatorBlockEntity = (IncubatorBlockEntity)level.m_7702_(pos);
        return incubatorBlockEntity.inv;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return this.lazyItemHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            UPMessages.sendToClients(new SyncItemStackC2SPacket(this.itemHandler, this.f_58858_));
            UPMessages.sendToClients(new SyncItemStackS2CPacket(this.inv, this.f_58858_));
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandlerOptional.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        if (this.inv != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.inv.size(); ++i) {
                ItemStack itemstack = this.inv.get(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128365_("Item", (Tag)itemstack.serializeNBT());
                nbttaglist.add((Object)CompoundNBT);
            }
            tag.m_128365_("Items", (Tag)nbttaglist);
        }
        tag.m_128405_("analyzer.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        if (this.inv == null) {
            this.inv = new ArrayList<ItemStack>();
        }
        if (this.inv != null) {
            ListTag nbttaglist = nbt.m_128437_("Items", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)CompoundNBT.m_128469_("Item"));
                this.inv.add(itemStack);
            }
        }
        this.progress = nbt.m_128451_("analyzer.progress");
    }

    public void setHandler(List<ItemStack> stacks) {
        this.inv.clear();
        this.inv.addAll(stacks);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.inv.size());
        for (int i = 0; i < this.inv.size(); ++i) {
            inventory.m_6836_(i, this.inv.get(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        this.inv.clear();
        if (!this.f_58857_.f_46443_) {
            UPMessages.sendToClients(new SyncItemStackS2CPacket(this.inv, this.f_58858_));
        }
    }

    public void m_5757_(Container pContainer) {
    }
}

