/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block.entity;

import com.peeko32213.unusualprehistory.common.data.AnalyzerRecipeJsonManager;
import com.peeko32213.unusualprehistory.common.screen.AnalyzerMenu;
import com.peeko32213.unusualprehistory.core.registry.UPBlockEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class AnalyzerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            AnalyzerBlockEntity.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private IItemHandler hopperHandler = new IItemHandler(){

        public int getSlots() {
            return AnalyzerBlockEntity.this.itemHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return AnalyzerBlockEntity.this.itemHandler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 && slot != 1) {
                return AnalyzerBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (slot == 0 && stack.m_150930_((Item)UPItems.FLASK.get())) {
                return AnalyzerBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            if (slot == 1 && stack.m_204117_(UPTags.ANALYZER_ITEMS_INPUT)) {
                return AnalyzerBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return AnalyzerBlockEntity.this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AnalyzerBlockEntity.this.itemHandler.isItemValid(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IItemHandler> hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AnalyzerBlockEntity.this.progress;
                case 1 -> AnalyzerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AnalyzerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AnalyzerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 8;
        }
    };
    private int progress = 0;
    private int maxProgress = 144;

    public AnalyzerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)UPBlockEntities.ANALYZER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"unusualprehistory.blockentity.analyzer");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.lazyItemHandlerOptional.cast();
            }
            return this.hopperHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
        this.hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandlerOptional.invalidate();
        this.hopperHandlerOptional.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("analyzer.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("analyzer.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, AnalyzerBlockEntity pBlockEntity) {
        if (AnalyzerBlockEntity.hasRecipe(pBlockEntity)) {
            pBlockEntity.progress = Math.min(pBlockEntity.progress + 1, pBlockEntity.maxProgress);
            AnalyzerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress >= pBlockEntity.maxProgress && !pLevel.m_5776_()) {
                AnalyzerBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            AnalyzerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(AnalyzerBlockEntity entity) {
        Level level = entity.f_58857_;
        if (AnalyzerRecipeJsonManager.getRecipes().isEmpty() && !level.f_46443_) {
            AnalyzerRecipeJsonManager.populateRecipeMap(level);
        }
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 1; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasRecipe = AnalyzerRecipeJsonManager.containsRecipe(inventory.m_8020_(1).m_41720_());
        return hasRecipe && AnalyzerBlockEntity.canInsertAmountIntoOutputSlot(inventory) && AnalyzerBlockEntity.hasFlaskInWaterSlot(entity);
    }

    private static boolean hasFlaskInWaterSlot(AnalyzerBlockEntity entity) {
        return entity.itemHandler.getStackInSlot(0).m_41720_() == UPItems.FLASK.get();
    }

    private static void craftItem(AnalyzerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasRecipe = AnalyzerRecipeJsonManager.containsRecipe(inventory.m_8020_(1).m_41720_());
        if (hasRecipe) {
            ItemStack result = AnalyzerRecipeJsonManager.getRandomItemStack(inventory.m_8020_(1).m_41720_(), level);
            entity.itemHandler.extractItem(1, 1, false);
            if (AnalyzerBlockEntity.isFilledFlask(result)) {
                entity.itemHandler.extractItem(0, 1, false);
            }
            boolean success = false;
            int n = entity.itemHandler.getSlots();
            for (int i = 2; i < n; ++i) {
                if (!entity.itemHandler.insertItem(i, result, false).m_41619_()) continue;
                success = true;
                break;
            }
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        int n = inventory.m_6643_();
        for (int slot = 2; slot < n; ++slot) {
            if (!inventory.m_8020_(slot).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private static boolean isFilledFlask(ItemStack itemStack) {
        return itemStack.m_204117_(UPTags.FILLED_FLASKS);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new AnalyzerMenu(pContainerId, pInventory, this, this.data);
    }
}

