/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block;

import com.peeko32213.unusualprehistory.common.block.entity.FruitLootBoxEntity;
import com.peeko32213.unusualprehistory.common.data.ItemWeightedPairCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitJsonManager;
import com.peeko32213.unusualprehistory.common.data.RollableItemCodec;
import com.peeko32213.unusualprehistory.core.registry.UPBlockEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BlockFruitLootBox
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LOOT_BOX = IntegerProperty.m_61631_((String)"loot_box", (int)1, (int)5);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final Logger LOGGER = LogManager.getLogger();
    private static final LootFruitCodec LOOT_FRUIT = new LootFruitCodec(2, "unusualprehistory.loot_fruit_box.default", Items.f_41911_, Collections.emptyList(), TextColor.m_131266_((int)12345), 2);
    private static final List<LootFruitCodec> LOOT_FRUIT_LIST = new ArrayList<LootFruitCodec>(){
        {
            this.add(LOOT_FRUIT);
        }
    };

    public BlockFruitLootBox(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        if (player.f_19853_.f_46443_) {
            CompoundTag tag = new CompoundTag();
            FruitLootBoxEntity fruitLootBox = (FruitLootBoxEntity)level.m_7702_(pos);
            String translationKey = fruitLootBox.getTranslationKey();
            int color = fruitLootBox.getColor();
            Item tradeItem = fruitLootBox.getTradeItem();
            int modelData = fruitLootBox.getCustomModelData();
            tag.m_128359_("translationKey", translationKey);
            tag.m_128405_("color", color);
            tag.m_128405_("CustomModelData", modelData);
            tag.m_128365_("tradeItem", (Tag)tradeItem.m_7968_().serializeNBT());
            itemStack.m_41751_(tag);
        }
        return itemStack;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_) {
            FruitLootBoxEntity fruitLootBox = (FruitLootBoxEntity)pLevel.m_7702_(pPos);
            try {
                int size = fruitLootBox.getLootFruits().size();
                if (!fruitLootBox.getLootFruits().isEmpty() && !pLevel.f_46443_) {
                    int randomNr = pLevel.f_46441_.m_188503_(size);
                    fruitLootBox.getLootFruits().get(randomNr).getItems().forEach(rollableItemCodec -> rollableItemCodec.dropItem(pLevel, pPos, (RollableItemCodec)rollableItemCodec));
                }
            }
            catch (Exception e) {
                LOGGER.info("failed due to ", (Throwable)e);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.m_7260_(pPos, pState, pState, 8);
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pLevel.f_46443_) {
            return;
        }
        FruitLootBoxEntity fruitLootBox = (FruitLootBoxEntity)pLevel.m_7702_(pPos);
        CompoundTag tag = pStack.m_41783_();
        if (tag != null) {
            fruitLootBox.setColor(tag.m_128451_("color"));
            Item tradeItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("tradeItem")).m_41720_();
            fruitLootBox.setTradeItem(tradeItem);
            if (LootFruitJsonManager.getLoot(tradeItem, null) == null) {
                return;
            }
            fruitLootBox.setColor(LootFruitJsonManager.getLoot(tradeItem, null).get(0).getColor().m_131265_());
            fruitLootBox.setLootFruits(LootFruitJsonManager.getLoot(tradeItem, null));
            int modelData = tag.m_128451_("CustomModelData");
            fruitLootBox.setCustomModelData(modelData);
            fruitLootBox.setTranslationKey(tag.m_128461_("translationKey"));
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LOOT_BOX, (Comparable)Integer.valueOf(modelData)));
            pLevel.m_7260_(pPos, pState, pState, 8);
            super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        }
    }

    public static float getCustomModelData(CompoundTag tag) {
        boolean flag = tag.m_128441_("CustomModelData");
        if (flag) {
            float modelData = tag.m_128451_("CustomModelData");
            return modelData;
        }
        return 0.0f;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        boolean isEmpty = LootFruitJsonManager.getTierTrades().isEmpty();
        if (!isEmpty) {
            Map<Integer, List<LootFruitCodec>> lootFruitItem = LootFruitJsonManager.getTierTrades();
            for (List<LootFruitCodec> lootFruitCodecs : lootFruitItem.values()) {
                for (LootFruitCodec lootFruitCodec : lootFruitCodecs) {
                    ItemStack istack = new ItemStack((ItemLike)this);
                    CompoundTag lootFruitTag = istack.m_41784_();
                    int color = lootFruitCodec.getColor().m_131265_();
                    lootFruitTag.m_128359_("translationKey", lootFruitCodec.getTranslationKey());
                    lootFruitTag.m_128405_("color", color);
                    lootFruitTag.m_128365_("tradeItem", (Tag)lootFruitCodec.getTradeItem().m_7968_().serializeNBT());
                    lootFruitTag.m_128405_("CustomModelData", lootFruitCodec.getCustomModelData());
                    istack.m_41751_(lootFruitTag);
                    list.add((Object)istack);
                }
            }
        } else {
            ItemStack istack = new ItemStack((ItemLike)this);
            ArrayList<ItemWeightedPairCodec> itemWeightedPairCodecs = new ArrayList<ItemWeightedPairCodec>();
            itemWeightedPairCodecs.add(new ItemWeightedPairCodec((Item)UPItems.PALEO_FOSSIL.get(), 100, 1));
            ArrayList<RollableItemCodec> rollableItemCodecs = new ArrayList<RollableItemCodec>();
            rollableItemCodecs.add(new RollableItemCodec(1, itemWeightedPairCodecs));
            LootFruitCodec lootFruitCodec = LOOT_FRUIT;
            CompoundTag lootFruitTag = istack.m_41784_();
            if (lootFruitCodec == null) {
                return;
            }
            int color = lootFruitCodec.getColor().m_131265_();
            lootFruitTag.m_128359_("translationKey", lootFruitCodec.getTranslationKey());
            lootFruitTag.m_128405_("color", color);
            lootFruitTag.m_128405_("CustomModelData", lootFruitCodec.getCustomModelData());
            lootFruitTag.m_128365_("tradeItem", (Tag)lootFruitCodec.getTradeItem().m_7968_().serializeNBT());
            istack.m_41751_(lootFruitTag);
            list.add((Object)istack);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)UPBlockEntities.FRUIT_LOOT_BOX_BLOCK_ENTITY.get()).m_155264_(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LOOT_BOX});
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (pStack.m_41782_()) {
            CompoundTag tag = pStack.m_41783_();
            String translationKey = tag.m_128461_("translationKey");
            ItemStack tradeItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("tradeItem"));
            int modelData = tag.m_128451_("CustomModelData");
            MutableComponent component = Component.m_237115_((String)"unusualprehistory.fruit_loot_box.loot_box");
            if (modelData == 1) {
                pStack.m_41714_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.WHITE));
            }
            if (modelData == 2) {
                pStack.m_41714_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.WHITE));
            }
            if (modelData == 3) {
                pStack.m_41714_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.YELLOW));
            }
            if (modelData == 4) {
                pStack.m_41714_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.AQUA));
            }
            if (modelData == 5) {
                pStack.m_41714_((Component)Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
    }
}

