/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block;

import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockDinosaurLandEggs
extends Block {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;
    private VoxelShape ONE_SHAPE;
    private VoxelShape MULTI_SHAPE;
    public static final VoxelShape EMPTY_BLOCK_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final VoxelShape ONE_EGG_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    public static final VoxelShape MULTI_EGG_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    private static int hatchTimeMax;
    private static int hatchTimeMin;
    private Supplier<? extends EntityType> dinosaur;
    private int eggCount;

    public BlockDinosaurLandEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, int eggCount, VoxelShape oneEgg, VoxelShape multiEgg, int hatchTimeMin, int hatchTimeMax) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76400_).m_60978_(0.5f).m_60918_(SoundType.f_56743_).m_60977_().m_60955_());
        this.eggCount = eggCount;
        this.dinosaur = dinosaur;
        this.ONE_SHAPE = oneEgg;
        this.MULTI_SHAPE = multiEgg;
        if (hatchTimeMin > hatchTimeMax) {
            try {
                LOGGER.debug("Min higher than Max, for block with entity {}", (Object)dinosaur.get());
                throw new Exception("Something went wrong setting creating block");
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"Something went wrong setting creating block");
                crashreport.m_127514_("Min higher than Max");
                throw new ReportedException(crashreport);
            }
        }
        BlockDinosaurLandEggs.hatchTimeMax = hatchTimeMax;
        BlockDinosaurLandEggs.hatchTimeMin = hatchTimeMin;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public BlockDinosaurLandEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, int eggCount, VoxelShape oneEgg) {
        this(properties, dinosaur, eggCount, oneEgg, EMPTY_BLOCK_SHAPE, 2400, 12000);
    }

    public BlockDinosaurLandEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, int eggCount, VoxelShape oneEgg, int hatchTimeMin, int hatchTimeMax) {
        this(properties, dinosaur, eggCount, oneEgg, EMPTY_BLOCK_SHAPE, hatchTimeMin, hatchTimeMax);
    }

    public BlockDinosaurLandEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, int eggCount) {
        this(properties, dinosaur, eggCount, ONE_EGG_SHAPE, MULTI_EGG_SHAPE, 2400, 12000);
    }

    public BlockDinosaurLandEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, int eggCount, int hatchTimeMin, int hatchTimeMax) {
        this(properties, dinosaur, eggCount, ONE_EGG_SHAPE, MULTI_EGG_SHAPE, hatchTimeMin, hatchTimeMax);
    }

    public BlockDinosaurLandEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, int eggCount, VoxelShape oneEgg, VoxelShape multiEgg) {
        this(properties, dinosaur, eggCount, oneEgg, multiEgg, 2400, 12000);
    }

    public static boolean hasProperHabitat(BlockGetter reader, BlockPos blockReader) {
        return BlockDinosaurLandEggs.isProperHabitat(reader, blockReader.m_7495_());
    }

    public static boolean isProperHabitat(BlockGetter reader, BlockPos pos) {
        return reader.m_8055_(pos).m_204336_(UPTags.DINO_HATCHABLE_BLOCKS);
    }

    protected boolean mayPlaceOn(BlockState p_56127_, BlockGetter p_56128_, BlockPos p_56129_) {
        return !p_56127_.m_60812_(p_56128_, p_56129_).m_83263_(Direction.UP).m_83281_() || p_56127_.m_60783_(p_56128_, p_56129_, Direction.UP);
    }

    public boolean m_7898_(BlockState p_56109_, LevelReader p_56110_, BlockPos p_56111_) {
        BlockPos blockpos = p_56111_.m_7495_();
        return this.mayPlaceOn(p_56110_.m_8055_(blockpos), (BlockGetter)p_56110_, blockpos);
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        this.tryTrample(worldIn, pos, entityIn, 100);
        super.m_141947_(worldIn, pos, state, entityIn);
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof Zombie)) {
            this.tryTrample(worldIn, pos, entityIn, 3);
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }

    private void tryTrample(Level worldIn, BlockPos pos, Entity trampler, int chances) {
        if (this.canTrample(worldIn, trampler) && !worldIn.f_46443_ && worldIn.f_46441_.m_188503_(chances) == 0) {
            BlockState blockstate = worldIn.m_8055_(pos);
            this.removeOneEgg(worldIn, pos, blockstate);
        }
    }

    public void growEgg(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.canGrow((Level)worldIn) && BlockDinosaurLandEggs.hasProperHabitat((BlockGetter)worldIn, pos)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                worldIn.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                worldIn.m_186460_(pos, (Block)this, worldIn.m_213780_().m_216339_(hatchTimeMin, hatchTimeMax));
            } else {
                worldIn.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                worldIn.m_7471_(pos, false);
                for (int j = 0; j < (Integer)state.m_61143_((Property)EGGS); ++j) {
                    worldIn.m_46796_(4001, pos, Block.m_49956_((BlockState)state));
                    Mob dinosaurToSpawn = (Mob)this.dinosaur.get().m_20615_((Level)worldIn);
                    if (dinosaurToSpawn instanceof IHatchableEntity) {
                        IHatchableEntity hatchableEntity = (IHatchableEntity)dinosaurToSpawn;
                        hatchableEntity.determineVariant(random.m_188503_(100));
                    }
                    if (dinosaurToSpawn instanceof Animal) {
                        Animal animal = (Animal)dinosaurToSpawn;
                        animal.m_146762_(-24000);
                    }
                    dinosaurToSpawn.m_21446_(pos, 20);
                    dinosaurToSpawn.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                    if (worldIn.f_46443_) continue;
                    worldIn.m_7967_((Entity)dinosaurToSpawn);
                }
            }
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.growEgg(state, level, pos, random);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188499_() && BlockDinosaurLandEggs.hasProperHabitat((BlockGetter)level, pos)) {
            this.m_213897_(state, level, pos, random);
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (BlockDinosaurLandEggs.hasProperHabitat((BlockGetter)worldIn, pos) && !worldIn.f_46443_) {
            worldIn.m_46796_(2005, pos, 0);
            worldIn.m_186460_(pos, (Block)this, worldIn.m_213780_().m_216339_(hatchTimeMin, hatchTimeMax));
        }
    }

    private boolean canGrow(Level worldIn) {
        return worldIn.f_46441_.m_188503_(5) == 0;
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        this.removeOneEgg(worldIn, pos, state);
    }

    private void removeOneEgg(Level worldIn, BlockPos pos, BlockState state) {
        worldIn.m_5594_(null, pos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)EGGS);
        if (i <= 1) {
            worldIn.m_46961_(pos, false);
        } else {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)EGGS) < this.eggCount || super.m_6864_(state, useContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60734_() == this ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(this.eggCount, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)EGGS) > 1 ? this.MULTI_SHAPE : this.ONE_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, EGGS});
    }

    private boolean canTrample(Level worldIn, Entity trampler) {
        if (trampler instanceof Bat || trampler.m_6095_() == this.dinosaur.get() || !(trampler instanceof LivingEntity)) {
            return false;
        }
        return trampler instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)trampler);
    }
}

