/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.client.render;

import com.peeko32213.unusualprehistory.client.render.dinosaur_renders.DinosaurRenderer;
import com.peeko32213.unusualprehistory.client.render.dinosaur_renders.TameableDinosaurRenderer;
import com.peeko32213.unusualprehistory.client.render.layer.BaseDinosaurSaddleLayer;
import com.peeko32213.unusualprehistory.client.render.layer.ItemHoldingLayer;
import com.peeko32213.unusualprehistory.client.render.layer.JebLayer;
import com.peeko32213.unusualprehistory.client.render.layer.TamableDinosaurSaddleLayer;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;

public class UPRenderUtils {
    public static <T extends EntityTameableBaseDinosaurAnimal> TamableDinosaurRendererBuilder<T> createTamableDinosaurRenderer(EntityRendererProvider.Context context, AnimatedGeoModel<T> model) {
        return new TamableDinosaurRendererBuilder<T>(context, model);
    }

    public static <T extends EntityBaseDinosaurAnimal> DinosaurRendererBuilder<T> createDinosaurRenderer(EntityRendererProvider.Context context, AnimatedGeoModel<T> model) {
        return new DinosaurRendererBuilder<T>(context, model);
    }

    public static class TamableDinosaurRendererBuilder<T extends EntityTameableBaseDinosaurAnimal> {
        private final EntityRendererProvider.Context context;
        private final AnimatedGeoModel<T> model;
        private final TameableDinosaurRenderer<T> dinoRenderer;
        private final List<GeoLayerRenderer<T>> layerFactories = new ArrayList<GeoLayerRenderer<T>>();
        private ResourceLocation modelLocation;

        private TamableDinosaurRendererBuilder(EntityRendererProvider.Context context, AnimatedGeoModel<T> model) {
            this.context = context;
            this.model = model;
            this.dinoRenderer = new TameableDinosaurRenderer<T>(context, model);
        }

        public TamableDinosaurRendererBuilder<T> withLayers(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }

        public TamableDinosaurRendererBuilder<T> withSaddleLayer(ResourceLocation saddleOverlay) {
            this.checkLayers();
            this.layerFactories.add(new TamableDinosaurSaddleLayer<T>(this.dinoRenderer, saddleOverlay, this.modelLocation));
            return this;
        }

        public TamableDinosaurRendererBuilder<T> withJebLayer(ResourceLocation jebOverlay) {
            this.checkLayers();
            this.layerFactories.add(new JebLayer<T>(this.dinoRenderer, jebOverlay, this.modelLocation));
            return this;
        }

        public TameableDinosaurRenderer<T> build() {
            this.checkLayers();
            for (GeoLayerRenderer<T> factory : this.layerFactories) {
                this.dinoRenderer.addLayer(factory);
            }
            return this.dinoRenderer;
        }

        private void checkLayers() {
            if (this.modelLocation == null) {
                throw new IllegalStateException("withLayers() must be called before adding other layers.");
            }
        }
    }

    public static class DinosaurRendererBuilder<T extends EntityBaseDinosaurAnimal> {
        private final EntityRendererProvider.Context context;
        private final AnimatedGeoModel<T> model;
        private final DinosaurRenderer<T> dinoRenderer;
        private final List<GeoLayerRenderer<T>> layerFactories = new ArrayList<GeoLayerRenderer<T>>();
        private ResourceLocation modelLocation;

        public DinosaurRendererBuilder(EntityRendererProvider.Context context, AnimatedGeoModel<T> model) {
            this.context = context;
            this.model = model;
            this.dinoRenderer = new DinosaurRenderer<T>(context, model);
        }

        public DinosaurRendererBuilder<T> withSaddleLayer(ResourceLocation saddleOverlay) {
            this.checkLayers();
            this.layerFactories.add(new BaseDinosaurSaddleLayer<T>(this.dinoRenderer, saddleOverlay, this.modelLocation));
            return this;
        }

        public DinosaurRendererBuilder<T> withItemHoldingLayer() {
            this.layerFactories.add(new ItemHoldingLayer<T>(this.dinoRenderer));
            return this;
        }

        public DinosaurRendererBuilder<T> withLayers(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }

        public DinosaurRenderer<T> build() {
            for (GeoLayerRenderer<T> factory : this.layerFactories) {
                this.dinoRenderer.addLayer(factory);
            }
            return this.dinoRenderer;
        }

        private void checkLayers() {
            if (this.modelLocation == null) {
                throw new IllegalStateException("withLayers() must be called before adding other layers.");
            }
        }
    }
}

