/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.IBlockStateUpdater;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.Nullable;

public class ModBlock
extends Block
implements IBlockStateUpdater {
    private static final IStackStorableTooltipBuilder EMPTY_STACK_STORABLE_TOOLTIP_BUILDER = (stack, data, world, appender, isAdvancedTooltip) -> {};
    private final boolean _stackStorable;
    private final IStackStorableTooltipBuilder _stackStorableTooltipBuilder;

    public static BlockBehaviour.Properties createProperties(MapColor color, SoundType soundType, float hardnessAndResistance) {
        return ModBlock.createProperties(color, soundType, hardnessAndResistance, hardnessAndResistance, false);
    }

    public static BlockBehaviour.Properties createProperties(MapColor color, SoundType soundType, float hardness, float resistance, boolean randomTick) {
        BlockBehaviour.Properties builder = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60913_(hardness, resistance).m_60918_(soundType);
        if (randomTick) {
            builder.m_60977_();
        }
        return builder;
    }

    public static Component getNameForTranslation(Block block) {
        return Component.m_237115_((String)block.m_7705_());
    }

    public static int lightValueFrom(float value) {
        return (int)(15.0f * value);
    }

    @Deprecated
    public ModBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this._stackStorable = false;
        this._stackStorableTooltipBuilder = EMPTY_STACK_STORABLE_TOOLTIP_BUILDER;
        this.m_49959_(this.buildDefaultState((BlockState)this.m_49965_().m_61090_()));
    }

    public ModBlock(ExtendedProperties extendedProperties) {
        super(extendedProperties._baseProperties);
        this._stackStorable = extendedProperties._stackStorable;
        this._stackStorableTooltipBuilder = extendedProperties._stackStorableTooltipBuilder;
        this.m_49959_(this.buildDefaultState((BlockState)this.m_49965_().m_61090_()));
    }

    public ItemStack createItemStack() {
        return ItemHelper.stackFrom((ItemLike)this, 1);
    }

    public ItemStack createItemStack(int amount) {
        return ItemHelper.stackFrom((ItemLike)this, amount);
    }

    public BlockItem createBlockItem(Item.Properties properties) {
        return new BlockItem((Block)this, properties);
    }

    public void callOnLogicalSide(Level world, Runnable serverCode, Runnable clientCode) {
        CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public <T> T callOnLogicalSide(Level world, Supplier<T> serverCode, Supplier<T> clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public boolean callOnLogicalSide(Level world, BooleanSupplier serverCode, BooleanSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public int callOnLogicalSide(Level world, IntSupplier serverCode, IntSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public long callOnLogicalSide(Level world, LongSupplier serverCode, LongSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public double callOnLogicalSide(Level world, DoubleSupplier serverCode, DoubleSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public void callOnLogicalServer(Level world, Runnable code) {
        CodeHelper.callOnLogicalServer(world, code);
    }

    public void callOnLogicalServer(Level world, Consumer<Level> code) {
        if (CodeHelper.calledByLogicalServer(world)) {
            code.accept(world);
        }
    }

    public <T> T callOnLogicalServer(Level world, Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalServer(Level world, BooleanSupplier code) {
        return CodeHelper.callOnLogicalServer(world, code);
    }

    public int callOnLogicalServer(Level world, IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public long callOnLogicalServer(Level world, LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public double callOnLogicalServer(Level world, DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public void callOnLogicalClient(Level world, Runnable code) {
        CodeHelper.callOnLogicalClient(world, code);
    }

    public void callOnLogicalClient(Level world, Consumer<Level> code) {
        if (CodeHelper.calledByLogicalClient(world)) {
            code.accept(world);
        }
    }

    public <T> T callOnLogicalClient(Level world, Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalClient(Level world, BooleanSupplier code) {
        return CodeHelper.callOnLogicalClient(world, code);
    }

    public int callOnLogicalClient(Level world, IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    public long callOnLogicalClient(Level world, LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    public double callOnLogicalClient(Level world, DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    @Override
    public void updateBlockState(BlockState currentState, LevelAccessor world, BlockPos position, @Nullable BlockEntity tileEntity, int updateFlags) {
        world.m_7731_(position, this.buildUpdatedState(currentState, (BlockGetter)world, position, tileEntity), updateFlags);
    }

    @Override
    public BlockState buildUpdatedState(BlockState currentState, BlockGetter reader, BlockPos position, @Nullable BlockEntity tileEntity) {
        return currentState;
    }

    public void m_6861_(BlockState state, Level world, BlockPos blockPosition, Block block, BlockPos neighborPosition, boolean isMoving) {
        super.m_6861_(state, world, blockPosition, block, neighborPosition, isMoving);
        if (this instanceof INeighborChangeListener.Notifier && this instanceof EntityBlock) {
            WorldHelper.getTile(world, blockPosition).filter(te -> te instanceof INeighborChangeListener).map(te -> (INeighborChangeListener)te).ifPresent(listener -> listener.onNeighborBlockChanged(state, neighborPosition, isMoving));
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos blockPosition, BlockPos neighborPosition) {
        BlockEntity te;
        super.onNeighborChange(state, world, blockPosition, neighborPosition);
        if (this instanceof INeighborChangeListener.Notifier && this instanceof EntityBlock && world instanceof Level && (te = WorldHelper.getLoadedTile((Level)world, blockPosition)) instanceof INeighborChangeListener) {
            ((INeighborChangeListener)te).onNeighborTileChanged(state, neighborPosition);
        }
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return super.m_7947_(state, reader, pos);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos position, int id, int param) {
        if (this instanceof EntityBlock) {
            return WorldHelper.getTile(world, position).map(tile -> tile.m_7531_(id, param)).orElse(super.m_8133_(state, world, position, id, param));
        }
        return super.m_8133_(state, world, position, id, param);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        if (this._stackStorable && stack.m_41782_()) {
            CompoundTag data = stack.m_41783_();
            if (data.m_128441_("BlockEntityTag")) {
                data = data.m_128469_("BlockEntityTag");
            }
            if (data.m_128441_("zcvase_payload")) {
                data = data.m_128469_("zcvase_payload");
            }
            this._stackStorableTooltipBuilder.build(stack, data, world, (NonNullConsumer<Component>)((NonNullConsumer)tooltip::add), flag.m_7050_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        this.buildBlockState(builder);
    }

    protected void buildBlockState(StateDefinition.Builder<Block, BlockState> builder) {
    }

    protected BlockState buildDefaultState(BlockState state) {
        return state;
    }

    @FunctionalInterface
    public static interface IStackStorableTooltipBuilder {
        public void build(ItemStack var1, CompoundTag var2, @Nullable BlockGetter var3, NonNullConsumer<Component> var4, boolean var5);
    }

    public static class ExtendedProperties<T extends ExtendedProperties<T>> {
        private BlockBehaviour.Properties _baseProperties = ModBlock.createProperties(MapColor.f_283947_, SoundType.f_56742_, 1.5f, 6.0f, false);
        private boolean _stackStorable;
        private IStackStorableTooltipBuilder _stackStorableTooltipBuilder;

        public ExtendedProperties() {
            this.setAsStackStorable(false);
        }

        public T setBlockProperties(BlockBehaviour.Properties properties) {
            this._baseProperties = properties;
            return this.self();
        }

        public T setAsStackStorable(boolean storable) {
            this._stackStorable = storable;
            this._stackStorableTooltipBuilder = EMPTY_STACK_STORABLE_TOOLTIP_BUILDER;
            return this.self();
        }

        public T setAsStackStorable(IStackStorableTooltipBuilder tooltipBuilder) {
            this._stackStorable = true;
            this._stackStorableTooltipBuilder = tooltipBuilder;
            return this.self();
        }

        private T self() {
            return (T)this;
        }
    }
}

