/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.redstone.sensor;

import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorSettingFactory;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSensorSettingData<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
extends AbstractData<SensorSetting>
implements IContainerData {
    private final Class<SensorType> _sensorTypeClass;
    private final ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> _factory;
    private SensorSetting _lastValue;

    protected AbstractSensorSettingData(Class<SensorType> sensorTypeClass, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> factory) {
        this._sensorTypeClass = sensorTypeClass;
        this._factory = factory;
    }

    protected AbstractSensorSettingData(Class<SensorType> sensorTypeClass, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> factory, NonNullSupplier<Supplier<SensorSetting>> serverSideGetter) {
        super(serverSideGetter);
        this._sensorTypeClass = sensorTypeClass;
        this._factory = factory;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        AbstractSensorSetting current = (AbstractSensorSetting)this._getter.get();
        if (null == this._lastValue || !this._lastValue.equals(current)) {
            this._lastValue = current.copy();
            return buffer -> {
                buffer.m_130068_(current.Sensor);
                buffer.m_130068_((Enum)current.Behavior);
                buffer.writeInt(current.Value1);
                buffer.writeInt(current.Value2);
            };
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        Enum type = dataSource.m_130066_(this._sensorTypeClass);
        SensorBehavior behavior = (SensorBehavior)dataSource.m_130066_(SensorBehavior.class);
        int value1 = dataSource.readInt();
        int value2 = dataSource.readInt();
        this.notify(this._factory.createSetting(type, behavior, value1, value2));
    }
}

