/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs;

import com.almostreliable.morejs.core.Events;
import com.almostreliable.morejs.features.misc.ExperiencePlayerEventJS;
import com.almostreliable.morejs.features.teleport.EntityTeleportsEventJS;
import com.almostreliable.morejs.features.teleport.TeleportType;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ForgeEventLoaders {
    public static void load(IEventBus bus) {
        bus.addListener(ForgeEventLoaders::onExperienceChange);
        bus.addListener(ForgeEventLoaders::chorusFruitTeleport);
        bus.addListener(ForgeEventLoaders::enderPearlTeleport);
    }

    private static void onExperienceChange(PlayerXpEvent.XpChange event) {
        ExperiencePlayerEventJS e = new ExperiencePlayerEventJS(event.getEntity(), event.getAmount());
        EventResult result = Events.XP_CHANGE.post((EventJS)e);
        event.setAmount(e.getAmount());
        if (result.interruptFalse()) {
            event.setCanceled(true);
        }
    }

    private static void chorusFruitTeleport(EntityTeleportEvent.ChorusFruit e) {
        ForgeEventLoaders.handleEvent((EntityTeleportEvent)e, TeleportType.CHORUS_FRUIT);
    }

    private static void enderPearlTeleport(EntityTeleportEvent.EnderPearl e) {
        ForgeEventLoaders.handleEvent((EntityTeleportEvent)e, TeleportType.ENDER_PEARL);
    }

    private static void handleEvent(EntityTeleportEvent e, TeleportType type) {
        EntityTeleportsEventJS event = new EntityTeleportsEventJS(e.getEntity(), e.getTargetX(), e.getTargetY(), e.getTargetZ(), type);
        if (Events.TELEPORT.post((EventJS)event).interruptFalse()) {
            e.setCanceled(true);
            return;
        }
        e.setTargetX(event.getX());
        e.setTargetY(event.getY());
        e.setTargetZ(event.getZ());
    }
}

