/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import earth.terrarium.adastra.client.utils.DimensionRenderingUtils;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.tags.ModBiomeTags;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=2000)
public abstract class LevelRendererMixin {
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    private int f_109477_;
    @Shadow
    private int f_109430_;
    @Shadow
    private int f_109431_;
    @Shadow
    private int f_109432_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    private Vec3 f_109433_;
    @Shadow
    private CloudStatus f_109435_;
    @Shadow
    private boolean f_109474_;
    @Shadow
    private VertexBuffer f_109475_;
    @Shadow
    private int f_109450_;

    @Shadow
    protected abstract BufferBuilder.RenderedBuffer m_234261_(BufferBuilder var1, double var2, double var4, double var6, Vec3 var8);

    @Inject(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V", shift=At.Shift.AFTER)})
    private void adastra$renderSnowAndRain(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (this.adastra$hasAcidRain()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DimensionRenderingUtils.ACID_RAIN);
        }
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$renderClouds(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (this.adastra$hasAcidRain()) {
            ci.cancel();
            float f = this.f_109465_.m_104583_().m_108871_();
            if (!Float.isNaN(f)) {
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.depthMask((boolean)true);
                double d1 = ((float)this.f_109477_ + partialTick) * 0.03f;
                double d2 = (camX + d1) / 12.0;
                double d3 = f - (float)camY + 0.33f;
                double d4 = camZ / 12.0 + (double)0.33f;
                d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
                d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
                float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
                float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
                float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
                Vec3 vec3 = this.f_109465_.m_104808_(partialTick);
                int i = (int)Math.floor(d2);
                int j = (int)Math.floor(d3 / 4.0);
                int k = (int)Math.floor(d4);
                if (i != this.f_109430_ || j != this.f_109431_ || k != this.f_109432_ || this.f_109461_.f_91066_.m_92174_() != this.f_109435_ || this.f_109433_.m_82557_(vec3) > 2.0E-4) {
                    this.f_109430_ = i;
                    this.f_109431_ = j;
                    this.f_109432_ = k;
                    this.f_109433_ = vec3;
                    this.f_109435_ = this.f_109461_.f_91066_.m_92174_();
                    this.f_109474_ = true;
                }
                if (this.f_109474_) {
                    this.f_109474_ = false;
                    BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                    if (this.f_109475_ != null) {
                        this.f_109475_.close();
                    }
                    this.f_109475_ = new VertexBuffer(VertexBuffer.Usage.STATIC);
                    BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.m_234261_(bufferbuilder, d2, d3, d4, vec3);
                    this.f_109475_.m_85921_();
                    this.f_109475_.m_231221_(bufferbuilder$renderedbuffer);
                    VertexBuffer.m_85931_();
                }
                RenderSystem.setShader(GameRenderer::m_172838_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)DimensionRenderingUtils.VENUS_CLOUDS);
                FogRenderer.m_109036_();
                poseStack.m_85836_();
                poseStack.m_85841_(12.0f, 1.0f, 12.0f);
                poseStack.m_252880_(-f3, f4, -f5);
                if (this.f_109475_ != null) {
                    int l;
                    this.f_109475_.m_85921_();
                    for (int i1 = l = this.f_109435_ == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                        if (i1 == 0) {
                            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                        } else {
                            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        }
                        ShaderInstance shaderinstance = RenderSystem.getShader();
                        assert (shaderinstance != null);
                        this.f_109475_.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
                    }
                    VertexBuffer.m_85931_();
                }
                poseStack.m_85849_();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            }
        }
    }

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra$tickRain(Camera camera, CallbackInfo ci) {
        if (this.adastra$hasAcidRain()) {
            ci.cancel();
            float f = Objects.requireNonNull(this.f_109461_.f_91073_).m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
            if (!(f <= 0.0f)) {
                RandomSource randomSource = RandomSource.m_216335_((long)((long)this.f_109477_ * 312987231L));
                ClientLevel levelReader = this.f_109461_.f_91073_;
                BlockPos blockPos = BlockPos.m_274446_((Position)camera.m_90583_());
                BlockPos blockPos2 = null;
                int i = (int)(100.0f * f * f) / (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
                for (int j = 0; j < i; ++j) {
                    Biome biome;
                    int l;
                    int k = randomSource.m_188503_(21) - 10;
                    BlockPos blockPos3 = levelReader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos.m_7918_(k, 0, l = randomSource.m_188503_(21) - 10));
                    if (blockPos3.m_123342_() <= levelReader.m_141937_() || blockPos3.m_123342_() > blockPos.m_123342_() + 10 || blockPos3.m_123342_() < blockPos.m_123342_() - 10 || (biome = (Biome)levelReader.m_204166_(blockPos3).m_203334_()).m_264600_(blockPos3) != Biome.Precipitation.RAIN) continue;
                    blockPos2 = blockPos3.m_7495_();
                    if (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
                    double d = randomSource.m_188500_();
                    double e = randomSource.m_188500_();
                    BlockState blockState = levelReader.m_8055_(blockPos2);
                    FluidState fluidState = levelReader.m_6425_(blockPos2);
                    VoxelShape voxelShape = blockState.m_60812_((BlockGetter)levelReader, blockPos2);
                    double g = voxelShape.m_83290_(Direction.Axis.Y, d, e);
                    double h = fluidState.m_76155_((BlockGetter)levelReader, blockPos2);
                    double m = Math.max(g, h);
                    SimpleParticleType particleOptions = !fluidState.m_205070_(FluidTags.f_13132_) && !blockState.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockState) ? (ParticleOptions)ModParticleTypes.ACID_RAIN.get() : ParticleTypes.f_123762_;
                    this.f_109461_.f_91073_.m_7106_((ParticleOptions)particleOptions, (double)blockPos2.m_123341_() + d, (double)blockPos2.m_123342_() + m, (double)blockPos2.m_123343_() + e, 0.0, 0.0, 0.0);
                }
                if (blockPos2 != null && randomSource.m_188503_(3) < this.f_109450_++) {
                    this.f_109450_ = 0;
                    if (blockPos2.m_123342_() > blockPos.m_123342_() + 1 && levelReader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > Mth.m_14143_((float)blockPos.m_123342_())) {
                        this.f_109461_.f_91073_.m_245747_(blockPos2, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                    } else {
                        this.f_109461_.f_91073_.m_245747_(blockPos2, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                    }
                }
            }
        }
    }

    @Unique
    private boolean adastra$hasAcidRain() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_9236_().m_204166_(player.m_20183_()).m_203656_(ModBiomeTags.HAS_ACID_RAIN);
    }
}

