/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.machines.common.blockentity.AlloySmelterBlockEntity;
import com.enderio.machines.common.blockentity.PrimitiveAlloySmelterBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class AlloySmeltingRecipe
implements MachineRecipe<ContainerWrapper> {
    private final ResourceLocation id;
    private final List<CountedIngredient> inputs;
    private final ItemStack output;
    private final int energy;
    private final float experience;
    private final boolean isSmelting;

    public AlloySmeltingRecipe(ResourceLocation id, List<CountedIngredient> inputs, ItemStack output, int energy, float experience, boolean isSmelting) {
        if (isSmelting && inputs.size() > 1) {
            throw new IllegalArgumentException("More than one smelting ingredient given");
        }
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.energy = energy;
        this.experience = experience;
        this.isSmelting = isSmelting;
    }

    public AlloySmeltingRecipe(ResourceLocation id, List<CountedIngredient> inputs, ItemStack output, int energy, float experience) {
        this(id, inputs, output, energy, experience, false);
    }

    public List<CountedIngredient> getInputs() {
        return this.inputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean isSmelting() {
        return this.isSmelting;
    }

    @Override
    public int getBaseEnergyCost() {
        return this.energy;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])this.inputs.stream().map(CountedIngredient::ingredient).toArray(Ingredient[]::new)));
    }

    public boolean matches(ContainerWrapper container, Level level) {
        int i;
        if (this.inputs.isEmpty()) {
            return false;
        }
        if (this.isSmelting) {
            int emptyCount = 0;
            for (int i2 = 0; i2 < 3; ++i2) {
                ItemStack slotItem = container.m_8020_(i2);
                if (slotItem.m_41619_()) {
                    ++emptyCount;
                    continue;
                }
                if (this.inputs.get(0).test(slotItem)) continue;
                return false;
            }
            return emptyCount < 3;
        }
        boolean[] matchedInputs = new boolean[3];
        MultiSlotAccess slotAccess = container.getSlotAccess();
        block1: for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (matchedInputs[j]) continue;
                ItemStack slotItem = slotAccess.get(i).getItemStack((Container)container);
                if (j < this.inputs.size()) {
                    if (!this.inputs.get(j).test(slotItem)) continue;
                    matchedInputs[j] = true;
                    continue block1;
                }
                if (!slotItem.m_41619_()) continue;
                matchedInputs[j] = true;
                continue block1;
            }
        }
        for (i = 0; i < 3; ++i) {
            if (matchedInputs[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<OutputStack> craft(ContainerWrapper container, RegistryAccess registryAccess) {
        ItemStack outputStack = this.output.m_41777_();
        if (this.isSmelting) {
            outputStack.m_41764_(outputStack.m_41613_() * container.inputsTaken);
        }
        return List.of(OutputStack.of(outputStack));
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        return List.of(OutputStack.of(this.output.m_41777_()));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.ALLOY_SMELTING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.ALLOY_SMELTING.type().get();
    }

    public static class ContainerWrapper
    extends RecipeWrapper {
        private final boolean isPrimitive;
        private int inputsTaken;

        public ContainerWrapper(boolean isPrimitive, IItemHandlerModifiable inv) {
            super(inv);
            this.isPrimitive = isPrimitive;
        }

        public MultiSlotAccess getSlotAccess() {
            return this.isPrimitive ? PrimitiveAlloySmelterBlockEntity.INPUTS : AlloySmelterBlockEntity.INPUTS;
        }

        public int getInputsTaken() {
            return this.inputsTaken;
        }

        public void setInputsTaken(int inputsTaken) {
            this.inputsTaken = inputsTaken;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlloySmeltingRecipe> {
        public AlloySmeltingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            JsonArray jsonInputs = serializedRecipe.getAsJsonArray("inputs");
            ArrayList<CountedIngredient> inputs = new ArrayList<CountedIngredient>(jsonInputs.size());
            for (int i = 0; i < jsonInputs.size(); ++i) {
                inputs.add(i, CountedIngredient.fromJson(jsonInputs.get(i).getAsJsonObject()));
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)serializedRecipe.getAsJsonObject("result"), (boolean)true);
            int energy = serializedRecipe.get("energy").getAsInt();
            float experience = serializedRecipe.get("experience").getAsFloat();
            boolean isSmelting = serializedRecipe.has("is_smelting") && serializedRecipe.get("is_smelting").getAsBoolean();
            return new AlloySmeltingRecipe(recipeId, inputs, result, energy, experience, isSmelting);
        }

        @Nullable
        public AlloySmeltingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                List ingredients = buffer.m_236845_(CountedIngredient::fromNetwork);
                ItemStack result = buffer.m_130267_();
                int energy = buffer.readInt();
                float experience = buffer.readFloat();
                return new AlloySmeltingRecipe(recipeId, ingredients, result, energy, experience);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading alloy smelting recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, AlloySmeltingRecipe recipe) {
            try {
                buffer.m_236828_(recipe.inputs, (buf, ing) -> ing.toNetwork((FriendlyByteBuf)buf));
                buffer.m_130055_(recipe.output);
                buffer.writeInt(recipe.energy);
                buffer.writeFloat(recipe.experience);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing alloy smelting recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

