/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.energy;

import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.common.conduit.type.SimpleConduitType;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitData;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitTicker;
import com.enderio.conduits.common.tag.ConduitTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyConduitType
extends SimpleConduitType<EnergyConduitData> {
    private static final ConduitMenuData MENU_DATA = new ConduitMenuData.Simple(false, false, false, false, false, true);

    public EnergyConduitType() {
        super(new EnergyConduitTicker(), EnergyConduitData::new, MENU_DATA);
    }

    @Override
    public ConduitType.ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        LazyOptional capability;
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
        if (blockEntity != null && (capability = blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)capability.orElseThrow(() -> new RuntimeException("present capability was not found"));
            if (!storage.canReceive() && !storage.canExtract()) {
                return new ConduitType.ConduitConnectionData(false, true, RedstoneControl.ALWAYS_ACTIVE);
            }
            return new ConduitType.ConduitConnectionData(storage.canReceive(), storage.canExtract(), RedstoneControl.ALWAYS_ACTIVE);
        }
        return super.getDefaultConnection(level, pos, direction);
    }

    @Override
    public <K> Optional<LazyOptional<K>> proxyCapability(Capability<K> cap, EnergyConduitData extendedConduitData, Level level, BlockPos pos, @Nullable Direction direction, @Nullable ConduitNode.IOState state) {
        if (!(ForgeCapabilities.ENERGY != cap || state != null && !state.isExtract() || direction != null && level.m_8055_(pos.m_121945_(direction)).m_204336_(ConduitTags.Blocks.ENERGY_CABLE))) {
            return Optional.of(extendedConduitData.getSelfCap().cast());
        }
        return Optional.empty();
    }
}

