/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.SlotType;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.client.ConduitClientSetup;
import com.enderio.conduits.common.conduit.ConduitGraphObject;
import com.enderio.conduits.common.conduit.ConduitTypeSorter;
import com.enderio.conduits.common.conduit.RightClickAction;
import com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
import com.enderio.conduits.common.conduit.connection.ConnectionState;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.conduit.connection.StaticConnectionStates;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;

public final class ConduitBundle
implements INBTSerializable<CompoundTag> {
    public static final int MAX_CONDUIT_TYPES = 9;
    private final Map<Direction, ConduitConnection> connections = new EnumMap<Direction, ConduitConnection>(Direction.class);
    private final List<ConduitType<?>> types = new ArrayList();
    private final Map<ConduitType<?>, ConduitGraphObject<?>> nodes = new HashMap();
    private final BlockPos pos;
    private final Map<Direction, BlockState> facadeTextures = new EnumMap<Direction, BlockState>(Direction.class);
    @Nullable
    private Runnable onChangedRunnable;
    private static final boolean IS_NEO_ENV_AFTER_ON_LOAD_CHANGE;
    private static final String KEY_TYPES = "Types";
    private static final String KEY_CONNECTIONS = "Connections";
    private static final String KEY_FACADES = "Facades";
    private static final String KEY_NODE_TYPE = "NodeType";
    private static final String KEY_NODE_DATA = "NodeData";
    private static final String KEY_NODES = "Nodes";
    private static final String KEY_DATA = "ExtendedDataBackup";

    public ConduitBundle(Runnable onChanged, BlockPos pos) {
        this.onChangedRunnable = onChanged;
        for (Direction value : Direction.values()) {
            this.connections.put(value, new ConduitConnection());
        }
        this.pos = pos;
    }

    public void setOnChangedRunnable(Runnable onChangedRunnable) {
        this.onChangedRunnable = onChangedRunnable;
    }

    public void onChanged() {
        if (this.onChangedRunnable != null) {
            this.onChangedRunnable.run();
        }
    }

    public <T extends ConduitData<T>> RightClickAction addType(Level level, ConduitType<T> type, Player player) {
        if (this.types.size() == 9) {
            return new RightClickAction.Blocked();
        }
        if (this.types.contains(type)) {
            return new RightClickAction.Blocked();
        }
        Optional<ConduitType> first = this.types.stream().filter(existingConduit -> existingConduit.canBeReplacedBy(type)).findFirst();
        ConduitGraphObject<Object> node = new ConduitGraphObject<T>(this.pos, type.createConduitData(level, this.pos));
        if (first.isPresent()) {
            int index = this.types.indexOf(first.get());
            this.types.set(index, type);
            ConduitGraphObject<?> prevNode = this.nodes.remove(first.get());
            if (prevNode != null) {
                node = new ConduitGraphObject(this.pos, prevNode.getConduitData());
                prevNode.getConduitData().onRemoved(type, level, this.pos);
                if (!level.m_5776_() && prevNode.getGraph() != null) {
                    prevNode.getGraph().remove(prevNode);
                }
            }
            this.nodes.put(type, node);
            node.getConduitData().onCreated(type, level, this.pos, player);
            this.onChanged();
            return new RightClickAction.Upgrade(first.get());
        }
        if (this.types.stream().anyMatch(existingConduit -> !existingConduit.canBeInSameBlock(type) || !type.canBeInSameBlock((ConduitType<?>)existingConduit))) {
            return new RightClickAction.Blocked();
        }
        int id = ConduitTypeSorter.getSortIndex(type);
        Optional<ConduitType> addBefore = this.types.stream().filter(existing -> ConduitTypeSorter.getSortIndex(existing) > id).findFirst();
        if (addBefore.isPresent()) {
            int value = this.types.indexOf(addBefore.get());
            this.types.add(value, type);
            this.nodes.put(type, node);
            node.getConduitData().onCreated(type, level, this.pos, player);
            for (Direction direction : Direction.values()) {
                this.connections.get(direction).addType(value);
            }
        } else {
            this.types.add(type);
            this.nodes.put(type, node);
            if (this.types.size() != 1 || !IS_NEO_ENV_AFTER_ON_LOAD_CHANGE) {
                node.getConduitData().onCreated(type, level, this.pos, player);
            }
        }
        this.onChanged();
        return new RightClickAction.Insert();
    }

    public void onLoad(Level level, BlockPos pos) {
        this.types.forEach(type -> this.onLoad((ConduitType)type, level, pos));
    }

    private <T extends ConduitData<T>> void onLoad(ConduitType<T> conduitType, Level level, BlockPos pos) {
        this.getNodeFor(conduitType).getConduitData().onCreated(conduitType, level, pos, null);
    }

    public boolean removeType(Level level, ConduitType<?> type) {
        int index = this.types.indexOf(type);
        if (index == -1) {
            if (!FMLLoader.isProduction()) {
                throw new IllegalArgumentException("Conduit: " + String.valueOf(EIOConduitTypes.REGISTRY.get().getKey(type)) + " is not present in conduit bundle " + Arrays.toString(this.types.stream().map(arg_0 -> EIOConduitTypes.REGISTRY.get().getKey(arg_0)).toArray()));
            }
            return this.types.isEmpty();
        }
        for (Direction direction : Direction.values()) {
            this.connections.get(direction).removeType(index);
        }
        if (EffectiveSide.get().isServer()) {
            this.removeNodeFor(level, type);
        }
        this.types.remove(index);
        this.onChanged();
        return this.types.isEmpty();
    }

    public List<ConduitType<?>> getConnectedTypes(Direction direction) {
        return this.connections.get(direction).getConnectedTypes(this);
    }

    @Deprecated(forRemoval=true)
    public ConnectionState getConnectionState(Direction direction, int index) {
        return this.connections.get(direction).getConnectionState(index);
    }

    public ConnectionState getConnectionState(Direction direction, ConduitType<?> conduitType) {
        return this.connections.get(direction).getConnectionState(this.getTypeIndex(conduitType));
    }

    public void setConnectionState(Direction direction, ConduitType<?> conduitType, ConnectionState state) {
        this.connections.get(direction).setConnectionState(this.getTypeIndex(conduitType), state);
        this.onChanged();
    }

    public boolean isConnectionEnd(Direction direction) {
        return this.connections.get(direction).isEnd();
    }

    public void removeType(Direction direction, ConduitType<?> conduitType) {
        this.connections.get(direction).removeType(this.getTypeIndex(conduitType));
        this.onChanged();
    }

    @Deprecated(forRemoval=true)
    public void disableType(Direction direction, int index) {
        this.connections.get(direction).disableType(index);
        this.onChanged();
    }

    public void disableType(Direction direction, ConduitType<?> conduitType) {
        this.disableType(direction, this.getTypeIndex(conduitType));
    }

    public ItemStack getConnectionItem(Direction direction, int conduitIndex, SlotType slotType) {
        return this.connections.get(direction).getItem(slotType, conduitIndex);
    }

    public ItemStack getConnectionItem(Direction direction, ConduitType<?> conduitType, SlotType slotType) {
        return this.getConnectionItem(direction, this.getTypeIndex(conduitType), slotType);
    }

    public void setConnectionItem(Direction direction, int conduitIndex, SlotType slotType, ItemStack itemStack) {
        this.connections.get(direction).setItem(slotType, conduitIndex, itemStack);
        this.onChanged();
    }

    public void setConnectionItem(Direction direction, ConduitType<?> conduitType, SlotType slotType, ItemStack itemStack) {
        this.setConnectionItem(direction, this.getTypeIndex(conduitType), slotType, itemStack);
    }

    public List<ConduitType<?>> getTypes() {
        return this.types;
    }

    public boolean hasFacade(Direction direction) {
        return this.facadeTextures.containsKey(direction);
    }

    public Optional<BlockState> getFacade(Direction direction) {
        return Optional.ofNullable(this.facadeTextures.get(direction));
    }

    public void setFacade(BlockState facade, Direction direction) {
        this.facadeTextures.put(direction, facade);
        this.onChanged();
    }

    public void connectTo(Level level, BlockPos pos, Direction direction, ConduitType<?> type, boolean end) {
        this.connections.get(direction).connectTo(level, pos, this.getNodeFor(type), direction, type, this.getTypeIndex(type), end);
        this.onChanged();
    }

    public boolean disconnectFrom(Direction direction, ConduitType<?> type) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!type.getTicker().canConnectTo(type, this.types.get(i))) continue;
            this.connections.get(direction).tryDisconnect(i);
            this.onChanged();
            return true;
        }
        return false;
    }

    @Nullable
    public ConduitGraphObject<?> getNodeForTypeExact(ConduitType<?> type) {
        return this.nodes.get(type);
    }

    public <T extends ConduitData<T>> ConduitGraphObject<T> getNodeFor(ConduitType<T> type) {
        for (Map.Entry<ConduitType<?>, ConduitGraphObject<?>> entry : this.nodes.entrySet()) {
            if (!entry.getKey().getTicker().canConnectTo(entry.getKey(), type)) continue;
            return this.nodes.get(entry.getKey());
        }
        throw new IllegalStateException("no node matching original type");
    }

    public void setNodeFor(ConduitType<?> type, ConduitGraphObject<?> node) {
        this.nodes.put(type, node);
        for (Direction direction : Direction.values()) {
            ConnectionState state;
            ConduitConnection connection = this.connections.get(direction);
            int index = this.types.indexOf(type);
            if (index < 0 || !((state = connection.getConnectionState(index)) instanceof DynamicConnectionState)) continue;
            DynamicConnectionState dynamicState = (DynamicConnectionState)state;
            ConduitBlockEntity.pushIOState(direction, node, dynamicState);
        }
    }

    public <T extends ConduitData<T>> void removeNodeFor(Level level, ConduitType<T> type) {
        ConduitGraphObject<?> node = this.nodes.get(type);
        node.getConduitData().onRemoved(type, level, this.pos);
        if (node.getGraph() != null) {
            node.getGraph().remove(node);
        }
        this.nodes.remove(type);
    }

    public boolean hasType(ConduitType<?> type) {
        for (ConduitType<?> conduitType : this.types) {
            if (!conduitType.getTicker().canConnectTo(conduitType, type)) continue;
            return true;
        }
        return false;
    }

    public int getTypeIndex(ConduitType<?> type) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getTicker().canConnectTo(this.types.get(i), type)) continue;
            return i;
        }
        throw new IllegalStateException("no conduit matching type in bundle");
    }

    public int hashCode() {
        int hash = Objects.hash(this.connections, this.types, this.facadeTextures);
        for (Map.Entry<ConduitType<?>, ConduitGraphObject<?>> entry : this.nodes.entrySet()) {
            hash = 31 * hash + entry.getKey().hashCode();
            hash = 31 * hash + entry.getValue().hashContents();
        }
        return hash;
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public ConduitBundle deepCopy() {
        ConduitBundle bundle = new ConduitBundle(() -> {}, this.pos);
        bundle.types.addAll(this.types);
        this.connections.forEach((dir, connection) -> bundle.connections.put((Direction)dir, connection.deepCopy()));
        bundle.facadeTextures.putAll(this.facadeTextures);
        this.nodes.forEach((type, node) -> bundle.setNodeFor((ConduitType<?>)type, node.deepCopy()));
        return bundle;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (ConduitType<?> conduitType : this.types) {
            listTag.add((Object)StringTag.m_129297_((String)EIOConduitTypes.REGISTRY.get().getKey(conduitType).toString()));
        }
        tag.m_128365_(KEY_TYPES, (Tag)listTag);
        CompoundTag connectionsTag = new CompoundTag();
        for (Direction dir : Direction.values()) {
            connectionsTag.m_128365_(dir.m_122433_(), (Tag)this.connections.get(dir).serializeNBT());
        }
        tag.m_128365_(KEY_CONNECTIONS, (Tag)connectionsTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<Direction, BlockState> entry : this.facadeTextures.entrySet()) {
            Tag blockStateTag = (Tag)BlockState.f_61039_.encode((Object)entry.getValue(), (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).get().left().orElse(new CompoundTag());
            compoundTag.m_128365_(entry.getKey().m_122433_(), blockStateTag);
        }
        tag.m_128365_(KEY_FACADES, (Tag)compoundTag);
        if (EffectiveSide.get().isServer()) {
            ListTag nodeTag = new ListTag();
            for (Map.Entry<ConduitType<?>, ConduitGraphObject<?>> entry : this.nodes.entrySet()) {
                CompoundTag data = (CompoundTag)entry.getValue().getConduitData().serializeNBT();
                if (data.m_128456_()) continue;
                CompoundTag dataTag = new CompoundTag();
                dataTag.m_128359_(KEY_NODE_TYPE, EIOConduitTypes.REGISTRY.get().getKey(entry.getKey()).toString());
                dataTag.m_128365_(KEY_NODE_DATA, (Tag)data);
                nodeTag.add((Object)dataTag);
            }
            if (!nodeTag.isEmpty()) {
                tag.m_128365_(KEY_NODES, (Tag)nodeTag);
            }
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(CompoundTag nbt) {
        block11: {
            block10: {
                void var7_11;
                Direction[] stringTag;
                this.types.clear();
                ListTag typesTag = nbt.m_128437_(KEY_TYPES, 8);
                ArrayList<Integer> invalidTypes = new ArrayList<Integer>();
                for (int i = 0; i < typesTag.size(); ++i) {
                    stringTag = (Direction[])typesTag.get(i);
                    ConduitType type2 = (ConduitType)EIOConduitTypes.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)stringTag.m_7916_()));
                    if (type2 == null) {
                        invalidTypes.add(i);
                        continue;
                    }
                    this.types.add(type2);
                }
                CompoundTag connectionsTag = nbt.m_128469_(KEY_CONNECTIONS);
                stringTag = Direction.values();
                int type2 = stringTag.length;
                boolean bl = false;
                while (var7_11 < type2) {
                    Direction dir = stringTag[var7_11];
                    this.connections.get(dir).deserializeNBT(connectionsTag.m_128469_(dir.m_122433_()));
                    for (Integer invalidType : invalidTypes) {
                        this.connections.get(dir).removeType(invalidType);
                    }
                    for (int i = invalidTypes.size() - 1; i >= 0; --i) {
                        this.connections.get(dir).removeType((Integer)invalidTypes.get(i));
                    }
                    ++var7_11;
                }
                this.facadeTextures.clear();
                CompoundTag facades = nbt.m_128469_(KEY_FACADES);
                for (Direction direction : Direction.values()) {
                    if (!facades.m_128441_(direction.m_122433_())) continue;
                    this.facadeTextures.put(direction, (BlockState)((Pair)BlockState.f_61039_.decode((DynamicOps)NbtOps.f_128958_, (Object)facades.m_128469_(direction.m_122433_())).get().left().get()).getFirst());
                }
                for (Map.Entry entry2 : this.facadeTextures.entrySet()) {
                    Tag blockStateTag = (Tag)BlockState.f_61039_.encode((Object)((BlockState)entry2.getValue()), (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).get().left().orElse(new CompoundTag());
                    facades.m_128365_(((Direction)entry2.getKey()).m_122433_(), blockStateTag);
                }
                this.nodes.entrySet().removeIf(entry -> !this.types.contains(entry.getKey()));
                if (!EffectiveSide.get().isServer()) break block10;
                for (ConduitType conduitType : this.types) {
                    if (!this.nodes.containsKey(conduitType)) continue;
                    for (Direction direction : Direction.values()) {
                        ConnectionState connectionState = this.connections.get(direction).getConnectionState(this.getTypeIndex(conduitType));
                        if (!(connectionState instanceof DynamicConnectionState)) continue;
                        DynamicConnectionState dyn = (DynamicConnectionState)connectionState;
                        ConduitBlockEntity.pushIOState(direction, this.nodes.get(conduitType), dyn);
                    }
                }
                break block11;
            }
            this.types.forEach(type -> this.createClientConduitGraphObject(this.pos, (ConduitType)type));
            if (!nbt.m_128441_(KEY_NODES)) break block11;
            ListTag nodesTag = nbt.m_128437_(KEY_NODES, 10);
            for (Tag tag : nodesTag) {
                CompoundTag cmp = (CompoundTag)tag;
                this.nodes.get(EIOConduitTypes.REGISTRY.get().getValue(new ResourceLocation(cmp.m_128461_(KEY_NODE_TYPE)))).getConduitData().deserializeNBT((Tag)cmp.m_128469_(KEY_NODE_DATA));
            }
        }
    }

    private <T extends ConduitData<T>> void createClientConduitGraphObject(BlockPos pos, ConduitType<T> conduitType) {
        if (!this.nodes.containsKey(conduitType)) {
            this.nodes.put(conduitType, new ConduitGraphObject<T>(pos, conduitType.createConduitData(ConduitClientSetup.getClientLevel(), pos)));
        }
    }

    static {
        IModInfo forge = (IModInfo)ModList.get().getModFileById("forge").getMods().get(0);
        IS_NEO_ENV_AFTER_ON_LOAD_CHANGE = forge.getDisplayName().equals("NeoForge") && forge.getVersion().compareTo((Object)new DefaultArtifactVersion("47.1.77")) >= 0;
    }

    private static final class ConduitConnection
    implements INBTSerializable<CompoundTag> {
        private final ConnectionState[] connectionStates = (ConnectionState[])Util.m_137537_(() -> {
            Object[] states = new ConnectionState[9];
            Arrays.fill(states, StaticConnectionStates.DISCONNECTED);
            return states;
        });
        private static final String KEY_STATIC = "Static";
        private static final String KEY_INDEX = "Index";
        private static final String KEY_IS_EXTRACT = "IsExtract";
        private static final String KEY_EXTRACT = "Extract";
        private static final String KEY_IS_INSERT = "IsInsert";
        private static final String KEY_INSERT = "Insert";
        private static final String KEY_REDSTONE_CONTROL = "RedstoneControl";
        private static final String KEY_REDSTONE_CHANNEL = "Channel";
        private static final String KEY_INSERT_FILTER = "InsertFilter";
        private static final String KEY_EXTRACT_UPGRADE = "ExtractUpgrade";
        private static final String KEY_EXTRACT_FILTER = "ExtractFilter";

        ConduitConnection() {
        }

        private ConduitConnection(List<ConnectionState> connectionStates) {
            if (connectionStates.size() > 9) {
                throw new IllegalArgumentException("Cannot store more than 9 conduit types per bundle.");
            }
            for (int i = 0; i < connectionStates.size(); ++i) {
                this.connectionStates[i] = connectionStates.get(i);
            }
        }

        public void addType(int index) {
            for (int i = 8; i > index; --i) {
                this.connectionStates[i] = this.connectionStates[i - 1];
            }
            this.connectionStates[index] = StaticConnectionStates.DISCONNECTED;
        }

        public void connectTo(Level level, BlockPos pos, ConduitGraphObject<?> conduitGraphObject, Direction direction, ConduitType<?> type, int typeIndex, boolean end) {
            if (end) {
                DynamicConnectionState state = DynamicConnectionState.defaultConnection(level, pos, direction, type);
                this.connectionStates[typeIndex] = state;
                ConduitBlockEntity.pushIOState(direction, conduitGraphObject, state);
            } else {
                this.connectionStates[typeIndex] = StaticConnectionStates.CONNECTED;
            }
        }

        public void tryDisconnect(int typeIndex) {
            if (this.connectionStates[typeIndex] != StaticConnectionStates.DISABLED) {
                this.connectionStates[typeIndex] = StaticConnectionStates.DISCONNECTED;
            }
        }

        public void removeType(int index) {
            this.connectionStates[index] = StaticConnectionStates.DISCONNECTED;
            for (int i = index + 1; i < 9; ++i) {
                this.connectionStates[i - 1] = this.connectionStates[i];
            }
            this.connectionStates[8] = StaticConnectionStates.DISCONNECTED;
        }

        public void disconnectType(int index) {
            this.connectionStates[index] = StaticConnectionStates.DISCONNECTED;
        }

        public void disableType(int index) {
            this.connectionStates[index] = StaticConnectionStates.DISABLED;
        }

        public boolean isEnd() {
            return Arrays.stream(this.connectionStates).anyMatch(DynamicConnectionState.class::isInstance);
        }

        public List<ConduitType<?>> getConnectedTypes(ConduitBundle bundle) {
            ArrayList connected = new ArrayList();
            List<ConduitType<?>> types = bundle.getTypes();
            for (int i = 0; i < this.connectionStates.length; ++i) {
                if (!this.connectionStates[i].isConnection() || types.size() <= i) continue;
                connected.add(types.get(i));
            }
            return connected;
        }

        public ConduitConnection deepCopy() {
            ConduitConnection connection = new ConduitConnection();
            System.arraycopy(this.connectionStates, 0, connection.connectionStates, 0, 9);
            return connection;
        }

        public ConnectionState getConnectionState(int index) {
            return this.connectionStates[index];
        }

        public void setConnectionState(int i, ConnectionState state) {
            this.connectionStates[i] = state;
        }

        public ItemStack getItem(SlotType type, int conduitIndex) {
            ConnectionState connectionState = this.connectionStates[conduitIndex];
            if (connectionState instanceof DynamicConnectionState) {
                DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)connectionState;
                return dynamicConnectionState.getItem(type);
            }
            return ItemStack.f_41583_;
        }

        public void setItem(SlotType type, int conduitIndex, ItemStack stack) {
            ConnectionState connectionState = this.connectionStates[conduitIndex];
            if (connectionState instanceof DynamicConnectionState) {
                DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)connectionState;
                this.connectionStates[conduitIndex] = dynamicConnectionState.withItem(type, stack);
            }
        }

        public int hashCode() {
            return Objects.hash(this.connectionStates);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            for (int i = 0; i < 9; ++i) {
                CompoundTag element = new CompoundTag();
                ConnectionState state = this.connectionStates[i];
                element.m_128379_(KEY_STATIC, state instanceof StaticConnectionStates);
                if (state instanceof StaticConnectionStates) {
                    StaticConnectionStates staticState = (StaticConnectionStates)state;
                    element.m_128405_(KEY_INDEX, staticState.ordinal());
                } else if (state instanceof DynamicConnectionState) {
                    DynamicConnectionState dynamicState = (DynamicConnectionState)state;
                    element.m_128379_(KEY_IS_EXTRACT, dynamicState.isExtract());
                    element.m_128405_(KEY_EXTRACT, dynamicState.extractChannel().ordinal());
                    element.m_128379_(KEY_IS_INSERT, dynamicState.isInsert());
                    element.m_128405_(KEY_INSERT, dynamicState.insertChannel().ordinal());
                    element.m_128405_(KEY_REDSTONE_CONTROL, dynamicState.control().ordinal());
                    element.m_128405_(KEY_REDSTONE_CHANNEL, dynamicState.redstoneChannel().ordinal());
                    element.m_128365_(KEY_INSERT_FILTER, (Tag)dynamicState.filterInsert().serializeNBT());
                    element.m_128365_(KEY_EXTRACT_FILTER, (Tag)dynamicState.filterExtract().serializeNBT());
                    element.m_128365_(KEY_EXTRACT_UPGRADE, (Tag)dynamicState.upgradeExtract().serializeNBT());
                }
                tag.m_128365_(String.valueOf(i), (Tag)element);
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            for (int i = 0; i < 9; ++i) {
                CompoundTag nbt = tag.m_128469_(String.valueOf(i));
                if (nbt.m_128471_(KEY_STATIC)) {
                    this.connectionStates[i] = StaticConnectionStates.values()[nbt.m_128451_(KEY_INDEX)];
                    continue;
                }
                boolean isExtract = nbt.m_128471_(KEY_IS_EXTRACT);
                int extractIndex = nbt.m_128451_(KEY_EXTRACT);
                boolean isInsert = nbt.m_128471_(KEY_IS_INSERT);
                int insertIndex = nbt.m_128451_(KEY_INSERT);
                int redControl = nbt.m_128451_(KEY_REDSTONE_CONTROL);
                int redChannel = nbt.m_128451_(KEY_REDSTONE_CHANNEL);
                ItemStack insertFilter = nbt.m_128425_(KEY_INSERT_FILTER, 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_(KEY_INSERT_FILTER)) : ItemStack.f_41583_;
                ItemStack extractFilter = nbt.m_128425_(KEY_EXTRACT_FILTER, 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_(KEY_EXTRACT_FILTER)) : ItemStack.f_41583_;
                ItemStack extractUpgrade = nbt.m_128425_(KEY_EXTRACT_UPGRADE, 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_(KEY_EXTRACT_UPGRADE)) : ItemStack.f_41583_;
                this.connectionStates[i] = new DynamicConnectionState(isInsert, ColorControl.values()[insertIndex], isExtract, ColorControl.values()[extractIndex], RedstoneControl.values()[redControl], ColorControl.values()[redChannel], insertFilter, extractFilter, extractUpgrade);
            }
        }
    }
}

