/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.network;

import com.enderio.api.travel.ITravelTarget;
import com.enderio.base.common.handler.TravelHandler;
import com.enderio.base.common.travel.TravelSavedData;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RequestTravelPacket
implements Packet {
    private final BlockPos pos;

    public RequestTravelPacket(BlockPos pos) {
        this.pos = pos;
    }

    public RequestTravelPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130064_(this.pos);
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerHandler.handle(context, this.pos);
    }

    public static class ServerHandler {
        static void handle(NetworkEvent.Context context, BlockPos pos) {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            TravelSavedData travelData = TravelSavedData.getTravelData(player.m_9236_());
            Optional<ITravelTarget> target = travelData.getTravelTarget(pos);
            if (!TravelHandler.canBlockTeleport((Player)player)) {
                player.m_5661_(Component.m_130674_((String)"ERROR: Cannot teleport"), true);
                return;
            }
            if (target.isEmpty()) {
                player.m_5661_(Component.m_130674_((String)"ERROR: Destination not a valid target"), true);
                return;
            }
            int range = Math.max(target.get().getBlock2BlockRange(), target.get().getItem2BlockRange());
            if (pos.m_123331_((Vec3i)player.m_20097_()) > (double)(range * range)) {
                player.m_5661_(Component.m_130674_((String)"ERROR: Too far"), true);
                return;
            }
            TravelHandler.blockTeleportTo(player.m_9236_(), (Player)player, target.get(), false);
        }
    }

    public static class Handler
    extends Packet.PacketHandler<RequestTravelPacket> {
        @Override
        public RequestTravelPacket fromNetwork(FriendlyByteBuf buf) {
            return new RequestTravelPacket(buf);
        }

        @Override
        public void toNetwork(RequestTravelPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

