/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.block.ColdFireBlock;
import com.enderio.base.common.capability.AcceptingFluidItemHandler;
import com.enderio.base.common.init.EIOBlocks;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.core.common.item.ITabVariants;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ColdFireIgniter
extends Item
implements IMultiCapabilityItem,
ITabVariants {
    public ColdFireIgniter(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack itemstack = context.m_43722_();
        Optional<IFluidHandlerItem> fluidCap = this.getTankCap(itemstack);
        if (fluidCap.isPresent()) {
            IFluidHandlerItem cap = fluidCap.get();
            if (cap.drain(10, IFluidHandler.FluidAction.SIMULATE).getAmount() == 10) {
                cap.drain(10, IFluidHandler.FluidAction.EXECUTE);
                Player player = context.m_43723_();
                Level level = context.m_43725_();
                BlockPos blockpos = context.m_8083_().m_121945_(context.m_43719_());
                BlockState coldFireState = ((ColdFireBlock)((Object)EIOBlocks.COLD_FIRE.get())).m_5573_(new BlockPlaceContext(context));
                if (coldFireState.m_60710_((LevelReader)context.m_43725_(), blockpos)) {
                    level.m_5594_(player, blockpos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                    level.m_7731_(blockpos, coldFireState, 11);
                    level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10591_.m_285767_(serverPlayer, blockpos, itemstack);
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
            return InteractionResult.FAIL;
        }
        LogManager.getLogger().warn("could not find FluidCapability on ColdFireIgniter");
        return super.m_6225_(context);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getTankCap(stack).isPresent();
    }

    public int m_142159_(ItemStack stack) {
        return 10075458;
    }

    public int m_142158_(ItemStack stack) {
        Optional<IFluidHandlerItem> tankCap = this.getTankCap(stack);
        if (tankCap.isPresent()) {
            IFluidHandlerItem fluidHandler = tankCap.get();
            return Math.round((float)fluidHandler.getFluidInTank(0).getAmount() * 13.0f / (float)fluidHandler.getTankCapacity(0));
        }
        return super.m_142158_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        this.getTankCap(stack).ifPresent(handler -> {
            boolean isOneTank;
            boolean bl = isOneTank = handler.getTanks() == 1;
            if (!isOneTank) {
                components.add((Component)Component.m_237113_((String)"Fluids:"));
            }
            for (int i = 0; i < handler.getTanks(); ++i) {
                Object prefix = isOneTank ? "" : i + ": ";
                MutableComponent postFix = handler.getFluidInTank(i).isEmpty() ? Component.m_237113_((String)"") : handler.getFluidInTank(i).getDisplayName();
                components.add((Component)Component.m_237113_((String)((String)prefix + handler.getFluidInTank(i).getAmount() + " / " + handler.getTankCapacity(i) + " ")).m_7220_((Component)postFix));
            }
        });
    }

    @Override
    public void addAllVariants(CreativeModeTabModifier modifier) {
        modifier.m_246326_((ItemLike)this);
        ItemStack is = new ItemStack((ItemLike)this);
        this.getTankCap(is).ifPresent(handler -> {
            if (handler instanceof AcceptingFluidItemHandler) {
                AcceptingFluidItemHandler fluidItemHandler = (AcceptingFluidItemHandler)((Object)handler);
                fluidItemHandler.setFluid(new FluidStack((Fluid)EIOFluids.VAPOR_OF_LEVITY.get(), handler.getTankCapacity(0)));
                modifier.m_246342_(is);
            }
        });
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(ForgeCapabilities.FLUID_HANDLER_ITEM, new AcceptingFluidItemHandler(stack, 1000, EIOTags.Fluids.COLD_FIRE_IGNITER_FUEL).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM));
        return provider;
    }

    private Optional<IFluidHandlerItem> getTankCap(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
    }
}

