/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.particle;

import com.enderio.base.common.particle.RangeParticleData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class RangeParticle
extends TextureSheetParticle {
    private final int range;
    private final float offset = 0.01f;

    public RangeParticle(ClientLevel level, Vec3 pos, int range, String color) {
        super(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.range = range;
        this.f_107225_ = 5;
        this.f_107227_ = (float)Integer.parseInt(color.substring(0, 2), 16) / 255.0f;
        this.f_107228_ = (float)Integer.parseInt(color.substring(2, 4), 16) / 255.0f;
        this.f_107229_ = (float)Integer.parseInt(color.substring(4, 6), 16) / 255.0f;
        this.f_107230_ = 0.11f;
        double bb_offset = 0.5;
        this.m_107259_(new AABB(pos.f_82479_ - (double)range - bb_offset, pos.f_82480_ - (double)range - bb_offset, pos.f_82481_ - (double)range - bb_offset, pos.f_82479_ + (double)range + bb_offset, pos.f_82480_ + (double)range + bb_offset, pos.f_82481_ + (double)range + bb_offset));
    }

    public void m_5744_(@NotNull VertexConsumer consumer, Camera renderInfo, float partialTicks) {
        Vec3 position = renderInfo.m_90583_();
        float mappedX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - position.m_7096_());
        float mappedY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - position.m_7098_());
        float mappedZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - position.m_7094_());
        Vector3f vec = new Vector3f((float)(-this.range) - 0.01f, (float)(-this.range) - 0.01f, (float)(this.range + 1) + 0.01f);
        this.renderFace(consumer, this.remapPosition(this.calcPoints(Direction.UP, vec), mappedX, mappedY, mappedZ));
        vec = new Vector3f((float)(-this.range) - 0.01f, (float)(-this.range) - 0.01f, (float)(-this.range) - 0.01f);
        this.renderFace(consumer, this.remapPosition(this.calcPoints(Direction.SOUTH, vec), mappedX, mappedY, mappedZ));
        this.renderFace(consumer, this.remapPosition(this.calcPoints(Direction.EAST, vec), mappedX, mappedY, mappedZ));
        this.renderFace(consumer, this.remapPosition(this.calcPoints(Direction.UP, vec), mappedX, mappedY, mappedZ));
        this.renderFace(consumer, this.remapPosition(this.calcPoints(Direction.NORTH, vec), mappedX, mappedY, mappedZ));
        this.renderFace(consumer, this.remapPosition(this.calcPoints(Direction.WEST, vec), mappedX, mappedY, mappedZ));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public Vector3f[] calcPoints(Direction face, Vector3f vec) {
        return this.calcPoints(face, vec.x(), vec.y(), vec.z(), (float)(2 * this.range + 1) + 0.02f, (float)(2 * this.range + 1) + 0.02f);
    }

    public Vector3f[] calcPoints(Direction face, float x, float y, float z, float w, float h) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.calcCoordinates(x, x + w, 1.0f - z, 1.0f - z, y, y, y + h, y + h);
            case Direction.UP -> this.calcCoordinates(x, x + w, z, z, y + h, y + h, y, y);
            case Direction.NORTH -> this.calcCoordinates(x, x + w, y + h, y, z, z, z, z);
            case Direction.SOUTH -> this.calcCoordinates(x, x + w, y, y + h, 1.0f - z, 1.0f - z, 1.0f - z, 1.0f - z);
            case Direction.WEST -> this.calcCoordinates(1.0f - z, 1.0f - z, y + h, y, x, x + w, x + w, x);
            case Direction.EAST -> this.calcCoordinates(z, z, y, y + h, x, x + w, x + w, x);
        };
    }

    private Vector3f[] remapPosition(Vector3f[] coords, float mappedX, float mappedY, float mappedZ) {
        for (Vector3f vec : coords) {
            vec.add(mappedX, mappedY, mappedZ);
        }
        return coords;
    }

    private Vector3f[] calcCoordinates(float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3) {
        return new Vector3f[]{new Vector3f(x0, y0, z0), new Vector3f(x1, y0, z1), new Vector3f(x1, y1, z2), new Vector3f(x0, y1, z3)};
    }

    private void renderFace(VertexConsumer consumer, Vector3f[] coords) {
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        this.addVertex(consumer, coords[0], minU, minV);
        this.addVertex(consumer, coords[1], maxU, minV);
        this.addVertex(consumer, coords[2], maxU, maxV);
        this.addVertex(consumer, coords[3], minU, maxV);
        this.addVertex(consumer, coords[1], maxU, minV);
        this.addVertex(consumer, coords[0], minU, minV);
        this.addVertex(consumer, coords[3], minU, maxV);
        this.addVertex(consumer, coords[2], maxU, maxV);
    }

    private void addVertex(VertexConsumer consumer, Vector3f pos, float u, float v) {
        consumer.m_5483_((double)pos.x(), (double)pos.y(), (double)pos.z()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(240, 240).m_5752_();
    }

    public static class Provider
    implements ParticleProvider<RangeParticleData> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(RangeParticleData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Vec3 pos = new Vec3(x, y, z);
            RangeParticle particle = new RangeParticle(level, pos, data.range(), data.color());
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

