/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.armory.common.capability;

import com.enderio.EnderIO;
import com.enderio.api.capability.IDarkSteelUpgradable;
import com.enderio.api.capability.IDarkSteelUpgrade;
import com.enderio.armory.common.item.darksteel.upgrades.DarkSteelUpgradeRegistry;
import com.enderio.armory.common.item.darksteel.upgrades.EmpoweredUpgradeTier;
import com.enderio.base.common.init.EIOCapabilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class DarkSteelUpgradeable
implements IDarkSteelUpgradable,
INBTSerializable<Tag> {
    private static final String ON_ITEM_KEY = "onItem";
    private final Map<String, IDarkSteelUpgrade> upgrades = new HashMap<String, IDarkSteelUpgrade>();
    private ResourceLocation onItem;

    public static ItemStack addUpgrade(ItemStack itemStack, IDarkSteelUpgrade upgrade) {
        itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).ifPresent(upgradable -> upgradable.addUpgrade(upgrade));
        return itemStack;
    }

    public static void removeUpgrade(ItemStack itemStack, String upgrade) {
        itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).ifPresent(upgradable -> upgradable.removeUpgrade(upgrade));
    }

    public static Collection<IDarkSteelUpgrade> getUpgrades(ItemStack itemStack) {
        return itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).map(IDarkSteelUpgradable::getUpgrades).orElse(Collections.emptyList());
    }

    public static boolean hasUpgrade(ItemStack itemStack, String name) {
        return itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).map(upgradable -> upgradable.hasUpgrade(name)).orElse(false);
    }

    public static <T extends IDarkSteelUpgrade> Optional<T> getUpgradeAs(ItemStack itemStack, String upgrade, Class<T> as) {
        Optional cap = itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).resolve();
        return cap.flatMap(upgradeCap -> upgradeCap.getUpgradeAs(upgrade, as));
    }

    public static Collection<IDarkSteelUpgrade> getUpgradesApplicable(ItemStack itemStack) {
        return itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).map(IDarkSteelUpgradable::getUpgradesApplicable).orElse(Collections.emptyList());
    }

    public static Collection<IDarkSteelUpgrade> getAllPossibleUpgrades(ItemStack itemStack) {
        return itemStack.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).map(IDarkSteelUpgradable::getAllPossibleUpgrades).orElse(Collections.emptyList());
    }

    public DarkSteelUpgradeable() {
        this(EnderIO.loc("empty"));
    }

    public DarkSteelUpgradeable(ResourceLocation onItem) {
        this.onItem = onItem;
    }

    @Override
    public void addUpgrade(IDarkSteelUpgrade upgrade) {
        this.removeUpgradeInSlot(upgrade.getSlot());
        this.upgrades.put(upgrade.getName(), upgrade);
    }

    @Override
    public void removeUpgrade(String name) {
        this.upgrades.remove(name);
    }

    private void removeUpgradeInSlot(String slot) {
        for (Map.Entry<String, IDarkSteelUpgrade> entry : this.upgrades.entrySet()) {
            if (!entry.getValue().getSlot().equals(slot)) continue;
            this.upgrades.remove(entry.getKey());
            break;
        }
    }

    @Override
    public boolean canApplyUpgrade(IDarkSteelUpgrade upgrade) {
        if (this.upgrades.isEmpty()) {
            return "enderio.darksteel.upgrade.empowered".equals(upgrade.getName()) && upgrade.isBaseTier();
        }
        Optional<IDarkSteelUpgrade> existing = this.getUpgrade(upgrade.getName());
        if (existing.isPresent()) {
            return existing.get().isValidUpgrade(upgrade);
        }
        if (!upgrade.isBaseTier()) {
            return false;
        }
        return DarkSteelUpgradeRegistry.instance().getUpgradesForItem(this.onItem).contains(upgrade.getName());
    }

    @Override
    public Optional<IDarkSteelUpgrade> getUpgrade(String upgrade) {
        return Optional.ofNullable(this.upgrades.get(upgrade));
    }

    @Override
    public Collection<IDarkSteelUpgrade> getUpgrades() {
        return this.upgrades.values();
    }

    @Override
    public boolean hasUpgrade(String upgrade) {
        return this.upgrades.containsKey(upgrade);
    }

    @Override
    public Collection<IDarkSteelUpgrade> getUpgradesApplicable() {
        if (this.upgrades.isEmpty()) {
            return List.of(EmpoweredUpgradeTier.ONE.getFactory().get());
        }
        ArrayList<IDarkSteelUpgrade> result = new ArrayList<IDarkSteelUpgrade>();
        this.upgrades.values().forEach(upgrade -> upgrade.getNextTier().ifPresent(result::add));
        this.getAllPossibleUpgrades().forEach(upgrade -> {
            if (!this.hasUpgrade(upgrade.getName())) {
                result.add((IDarkSteelUpgrade)upgrade);
            }
        });
        return result;
    }

    @Override
    public Collection<IDarkSteelUpgrade> getAllPossibleUpgrades() {
        Set<String> upgradeNames = DarkSteelUpgradeRegistry.instance().getUpgradesForItem(this.onItem);
        ArrayList<IDarkSteelUpgrade> result = new ArrayList<IDarkSteelUpgrade>();
        upgradeNames.forEach(s -> DarkSteelUpgradeRegistry.instance().createUpgrade((String)s).ifPresent(result::add));
        return result;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, IDarkSteelUpgrade> entry : this.upgrades.entrySet()) {
            tag.m_128365_(entry.getKey(), entry.getValue().serializeNBT());
        }
        tag.m_128359_(ON_ITEM_KEY, this.onItem.toString());
        return tag;
    }

    public void deserializeNBT(Tag tag) {
        this.upgrades.clear();
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            for (String key : nbt.m_128431_()) {
                DarkSteelUpgradeRegistry.instance().createUpgrade(key).ifPresent(upgrade -> {
                    upgrade.deserializeNBT(Objects.requireNonNull(nbt.m_128423_(key)));
                    this.addUpgrade((IDarkSteelUpgrade)upgrade);
                });
            }
            this.onItem = new ResourceLocation(nbt.m_128461_(ON_ITEM_KEY));
        }
    }
}

