/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TieredConduit<T extends ConduitData<T>>
extends ConduitType<T> {
    private final ResourceLocation type;
    private final int tier;
    protected final ResourceLocation tierName;

    public TieredConduit(ResourceLocation type, ResourceLocation tierName, int tier) {
        this.type = type;
        this.tier = tier;
        this.tierName = tierName;
    }

    @Override
    public boolean canBeReplacedBy(ConduitType<?> other) {
        if (!(other instanceof TieredConduit)) {
            return false;
        }
        TieredConduit tieredOther = (TieredConduit)other;
        if (this.type.equals((Object)tieredOther.getType())) {
            return this.tier < tieredOther.getTier();
        }
        return false;
    }

    @Override
    public boolean canBeInSameBlock(ConduitType<?> other) {
        if (!(other instanceof TieredConduit)) {
            return true;
        }
        TieredConduit tieredOther = (TieredConduit)other;
        return !this.type.equals((Object)tieredOther.getType());
    }

    @Override
    public Item getConduitItem() {
        return Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(this.tierName));
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public int getTier() {
        return this.tier;
    }
}

