/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitType;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public interface ConduitData<T extends ConduitData<T>>
extends INBTSerializable<CompoundTag> {
    public static final EmptyConduitData EMPTY = new EmptyConduitData();

    default public void onCreated(ConduitType<?> type, Level level, BlockPos pos, @Nullable Player player) {
    }

    default public void onRemoved(ConduitType<?> type, Level level, BlockPos pos) {
    }

    default public void updateConnection(Set<Direction> connectedSides) {
    }

    default public boolean canConnectTo(T otherData) {
        return true;
    }

    default public void onConnectTo(T otherData) {
    }

    default public CompoundTag serializeGuiNBT() {
        return new CompoundTag();
    }

    @UseOnly(value=LogicalSide.CLIENT)
    default public T deepCopy() {
        return (T)this.cast();
    }

    default public <Z extends ConduitData<Z>> Z cast() {
        return (Z)this;
    }

    default public <Z extends ConduitData<Z>> Z castTo(Class<Z> clazz) {
        return this.cast();
    }

    public static class EmptyConduitData
    implements ConduitData<EmptyConduitData> {
        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }
    }
}

