/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.compat.jei.category;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mrthomas20121.thermal_extra.client.screens.machine.MachineFluidMixerScreen;
import mrthomas20121.thermal_extra.init.ThermalExtraBlocks;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipe;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipeManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class FluidMixerRecipeCategory
extends ThermalRecipeCategory<FluidMixerRecipe> {
    protected IDrawableStatic tankInputA;
    protected IDrawableStatic tankInputB;
    protected IDrawableStatic tankOutputC;
    protected IDrawableStatic tankOutputD;
    protected IDrawableStatic tankOverlayA;
    protected IDrawableStatic tankOverlayB;
    protected IDrawableStatic tankOverlayD;
    protected IDrawableStatic tankOverlayC;

    public FluidMixerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<FluidMixerRecipe> type) {
        super(guiHelper, icon, type);
        this.energyMod = () -> Float.valueOf(FluidMixerRecipeManager.instance().getDefaultScale());
        this.background = guiHelper.drawableBuilder(MachineFluidMixerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalExtraBlocks.BLOCKS.get("fluid_mixer")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2);
        this.tankInputA = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlayA = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.tankInputB = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlayB = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.tankOutputC = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlayC = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.tankOutputD = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlayD = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2), 200, IDrawableAnimated.StartDirection.LEFT, true);
    }

    public RecipeType<FluidMixerRecipe> getRecipeType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidMixerRecipe recipe, IFocusGroup focuses) {
        List inputFluids = recipe.getInputFluids();
        List outputFluids = recipe.getOutputFluids();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(((FluidIngredient)inputFluids.get(0)).getFluids()))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlayA, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 52, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(((FluidIngredient)inputFluids.get(1)).getFluids()))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlayB, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 11).addFluidStack(((FluidStack)outputFluids.get(0)).getFluid(), (long)((FluidStack)outputFluids.get(0)).getAmount())).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlayC, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        boolean bool = outputFluids.size() == 2;
        IRecipeSlotBuilder b = builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 11).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlayD, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        if (bool) {
            b.addFluidStack(((FluidStack)outputFluids.get(1)).getFluid(), (long)((FluidStack)outputFluids.get(1)).getAmount());
        }
    }

    public void draw(FluidMixerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.progressBackground.draw(guiGraphics, 78, 24);
        this.tankInputA.draw(guiGraphics, 24, 10);
        this.tankInputB.draw(guiGraphics, 51, 10);
        this.tankOutputC.draw(guiGraphics, 114, 10);
        this.tankOutputD.draw(guiGraphics, 141, 10);
        RenderHelper.drawFluid((GuiGraphics)guiGraphics, (int)78, (int)24, (FluidStack)((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()[0], (int)24, (int)16);
        this.progressFluidBackground.draw(guiGraphics, 78, 24);
        this.progressFluid.draw(guiGraphics, 78, 24);
    }
}

