/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper.terrainzapper;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.zapper.ZapperItemRenderer;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class WorldshaperItemRenderer
extends ZapperItemRenderer {
    protected static final PartialModel CORE = new PartialModel(Create.asResource("item/handheld_worldshaper/core"));
    protected static final PartialModel CORE_GLOW = new PartialModel(Create.asResource("item/handheld_worldshaper/core_glow"));
    protected static final PartialModel ACCELERATOR = new PartialModel(Create.asResource("item/handheld_worldshaper/accelerator"));

    @Override
    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.render(stack, model, renderer, transformType, ms, buffer, light, overlay);
        float pt = AnimationTickHolder.getPartialTicks();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        renderer.renderSolid(model.getOriginalModel(), light);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean leftHanded = player.m_5737_() == HumanoidArm.LEFT;
        boolean mainHand = player.m_21205_() == stack;
        boolean offHand = player.m_21206_() == stack;
        float animation = this.getAnimationProgress(pt, leftHanded, mainHand);
        float multiplier = mainHand || offHand ? animation : Mth.m_14031_((float)(worldTime * 5.0f));
        int lightItensity = (int)(15.0f * Mth.m_14036_((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = LightTexture.m_109885_((int)lightItensity, (int)Math.max(lightItensity, 4));
        renderer.renderSolidGlowing(CORE.get(), glowLight);
        renderer.renderGlowing(CORE_GLOW.get(), glowLight);
        float angle = worldTime * -25.0f;
        if (mainHand || offHand) {
            angle += 360.0f * animation;
        }
        float offset = -0.155f;
        ms.m_252880_(0.0f, offset, 0.0f);
        ms.m_252781_(Axis.f_252403_.m_252977_(angle %= 360.0f));
        ms.m_252880_(0.0f, -offset, 0.0f);
        renderer.render(ACCELERATOR.get(), light);
    }
}

