/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.UnknownPartEvent;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.PartTypeRegistry;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class PartHelpers {
    public static LazyOptional<IPartContainer> getPartContainer(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, PartContainerConfig.CAPABILITY);
    }

    public static LazyOptional<IPartContainer> getPartContainer(DimPos dimPos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((DimPos)dimPos, (Direction)side, PartContainerConfig.CAPABILITY);
    }

    public static IPartContainer getPartContainerChecked(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return (IPartContainer)PartHelpers.getPartContainer(world, pos, side).orElseThrow(() -> new PartStateException(DimPos.of((Level)((Level)world), (BlockPos)pos), side));
    }

    public static IPartContainer getPartContainerChecked(DimPos dimPos, @Nullable Direction side) {
        return (IPartContainer)PartHelpers.getPartContainer(dimPos, side).orElseThrow(() -> new PartStateException(dimPos, side));
    }

    public static IPartContainer getPartContainerChecked(PartPos pos) {
        return PartHelpers.getPartContainerChecked(pos.getPos(), pos.getSide());
    }

    public static IPartType validatePartType(INetwork network, String partTypeName, @Nullable IPartType partType) {
        if (network != null && partType == null) {
            UnknownPartEvent event = new UnknownPartEvent(network, partTypeName);
            network.getEventBus().post(event);
            partType = event.getPartType();
        }
        return partType;
    }

    public static void writePartTypeToNBT(CompoundTag partTag, Direction side, IPartType partType) {
        partTag.m_128359_("__partType", partType.getUniqueName().toString());
        partTag.m_128359_("__side", side.m_7912_());
    }

    public static boolean writePartToNBT(BlockPos pos, CompoundTag partTag, Pair<Direction, PartStateHolder<?, ?>> partData) {
        IPartType part = ((PartStateHolder)partData.getValue()).getPart();
        Object partState = ((PartStateHolder)partData.getValue()).getState();
        PartHelpers.writePartTypeToNBT(partTag, (Direction)partData.getKey(), part);
        try {
            part.toNBT(partTag, partState);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, String.format("The part %s at position %s was errored and is removed.", part.getUniqueName(), pos));
            return false;
        }
    }

    public static void writePartsToNBT(BlockPos pos, CompoundTag tag, Map<Direction, PartStateHolder<?, ?>> partData) {
        ListTag partList = new ListTag();
        Iterator<Map.Entry<Direction, PartStateHolder<?, ?>>> iterator = partData.entrySet().iterator();
        while (iterator.hasNext()) {
            CompoundTag partTag = new CompoundTag();
            Map.Entry<Direction, PartStateHolder<?, ?>> entry = iterator.next();
            if (!PartHelpers.writePartToNBT(pos, partTag, Pair.of((Object)entry.getKey(), entry.getValue()))) continue;
            partList.add((Object)partTag);
        }
        tag.m_128365_("parts", (Tag)partList);
    }

    public static Pair<Direction, IPartType> readPartTypeFromNBT(@Nullable INetwork network, BlockPos pos, CompoundTag partTag) {
        String partTypeName = partTag.m_128461_("__partType");
        IPartType partType = PartHelpers.validatePartType(network, partTypeName, PartTypes.REGISTRY.getPartType(new ResourceLocation(partTypeName)));
        if (partType != null) {
            Direction side = Direction.m_122402_((String)partTag.m_128461_("__side"));
            if (side != null) {
                return Pair.of((Object)side, (Object)partType);
            }
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part %s at position %s was at an invalid side and removed.", partType.getUniqueName(), pos));
        } else {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part %s at position %s was unknown and removed.", partTypeName, pos));
        }
        return null;
    }

    public static Pair<Direction, ? extends PartStateHolder<?, ?>> readPartFromNBT(@Nullable INetwork network, BlockPos pos, CompoundTag partTag, Level level) {
        Pair<Direction, IPartType> partData = PartHelpers.readPartTypeFromNBT(network, pos, partTag);
        if (partData != null) {
            Object partState = ((IPartType)partData.getValue()).fromNBT(ValueDeseralizationContext.of(level), partTag);
            return Pair.of((Object)((Direction)partData.getKey()), PartStateHolder.of((IPartType)partData.getValue(), partState));
        }
        return null;
    }

    public static void readPartsFromNBT(@Nullable INetwork network, BlockPos pos, CompoundTag tag, Map<Direction, PartStateHolder<?, ?>> partData, Level world) {
        ImmutableMap oldPartData = ImmutableMap.copyOf(partData);
        partData.clear();
        ListTag partList = tag.m_128437_("parts", 10);
        for (int i = 0; i < partList.size(); ++i) {
            CompoundTag partTag = partList.m_128728_(i);
            Pair<Direction, ? extends PartStateHolder<?, ?>> part = PartHelpers.readPartFromNBT(network, pos, partTag, world);
            if (part == null) continue;
            partData.put((Direction)part.getKey(), (PartStateHolder)part.getValue());
        }
        if (world != null && world.m_5776_()) {
            boolean triggerBlockRenderUpdate = false;
            for (Direction side : Direction.values()) {
                Object newPartState;
                PartStateHolder oldData = (PartStateHolder)oldPartData.get(side);
                PartStateHolder<?, ?> newData = partData.get(side);
                if (oldData == null && newData == null) continue;
                IPartType oldPartType = oldData != null ? oldData.getPart() : null;
                IPartType<?, ?> newPartType = newData != null ? newData.getPart() : null;
                Object oldPartState = oldData != null ? (Object)oldData.getState() : null;
                Object s = newPartState = newData != null ? (Object)newData.getState() : null;
                if (oldPartType == newPartType && !oldPartType.shouldTriggerBlockRenderUpdate(oldPartState, newPartState)) continue;
                triggerBlockRenderUpdate = true;
                break;
            }
            if (triggerBlockRenderUpdate) {
                BlockHelpers.markForUpdate((Level)world, (BlockPos)pos);
            }
        }
    }

    public static boolean removePart(Level world, BlockPos pos, Direction side, @Nullable Player player, boolean destroyIfEmpty, boolean dropMainElement, boolean saveState) {
        boolean removeCompletely;
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((BlockGetter)world, pos, side);
        ICableFakeable cableFakeable = (ICableFakeable)CableHelpers.getCableFakeable((BlockGetter)world, pos, side).orElse(null);
        partContainer.removePart(side, player, dropMainElement, saveState);
        boolean bl = removeCompletely = destroyIfEmpty && (cableFakeable == null || !cableFakeable.isRealCable()) && !partContainer.hasParts();
        if (removeCompletely) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        } else {
            world.m_46672_(pos, world.m_8055_(pos).m_60734_());
            if (CableHelpers.getCable((BlockGetter)world, pos.m_121945_(side), side.m_122424_()).isPresent()) {
                CableHelpers.updateConnections((BlockGetter)world, pos, side);
                CableHelpers.updateConnections((BlockGetter)world, pos.m_121945_(side), side.m_122424_());
                NetworkHelpers.initNetwork(world, pos, side);
            }
        }
        return !removeCompletely;
    }

    public static boolean addPart(Level level, BlockPos pos, Direction side, IPartType partType, ItemStack itemStack) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((BlockGetter)level, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!level.m_5776_()) {
                partContainer.setPart(side, partType, partType.getState(ValueDeseralizationContext.of(level), itemStack));
            }
            return true;
        }
        return false;
    }

    public static boolean addPart(Level world, BlockPos pos, Direction side, IPartType partType, IPartState partState) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((BlockGetter)world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.m_5776_()) {
                partContainer.setPart(side, partType, partState);
            }
            return true;
        }
        return false;
    }

    public static boolean setPart(@Nullable INetwork network, Level world, BlockPos pos, Direction side, IPartType part, IPartState partState, IPartStateHolderCallback callback) {
        callback.onSet(PartStateHolder.of(part, partState));
        if (network != null) {
            IPartContainer partContainer = PartHelpers.getPartContainerChecked((BlockGetter)world, pos, side);
            INetworkElement networkElement = part.createNetworkElement(partContainer, DimPos.of((Level)world, (BlockPos)pos), side);
            if (!network.addNetworkElement(networkElement, false)) {
                partState = part.defaultBlockState();
                callback.onSet(PartStateHolder.of(part, partState));
                IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, "A part already existed in the network, this is possibly a result from item duplication.");
                network.addNetworkElement(networkElement, false);
            }
            return true;
        }
        return false;
    }

    public static boolean canInteractWith(PartTarget target, Player player, IPartContainer expectedPartContainer) {
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(target.getCenter().getPos(), target.getCenter().getSide()).orElse(null);
        return partContainer == expectedPartContainer;
    }

    @Nullable
    public static PartStateHolder<?, ?> getPart(PartPos partPos) {
        Direction side = partPos.getSide();
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(partPos.getPos(), partPos.getSide()).orElse(null);
        if (partContainer != null && partContainer.hasPart(side)) {
            return PartStateHolder.of(partContainer.getPart(side), partContainer.getPartState(side));
        }
        return null;
    }

    public static InteractionResult openContainerPart(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProvider(pos).map(containerProvider -> {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> partType.writeExtraGuiData((FriendlyByteBuf)packetBuffer, pos, player));
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    public static boolean openContainerPartSettings(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderSettings(pos).map(containerProvider -> {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> partType.writeExtraGuiDataSettings((FriendlyByteBuf)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static void openContainerAspectSettings(ServerPlayer player, PartPos pos, IAspect<?, ?> aspect) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)aspect.getPropertiesContainerProvider(pos), packetBuffer -> packetBuffer.m_130070_(aspect.getUniqueName().toString()));
    }

    public static boolean openContainerPartOffsets(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderOffsets(pos).map(containerProvider -> {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> partType.writeExtraGuiDataOffsets((FriendlyByteBuf)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static Triple<IPartContainer, PartTypeBase, PartTarget> getContainerPartConstructionData(PartPos pos) {
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer(pos.getPos(), pos.getSide()).orElse(null);
        if (partContainer == null) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The tile at %s is not a valid part container.", pos));
            return null;
        }
        IPartType partType = partContainer.getPart(pos.getSide());
        if (partType == null || !(partType instanceof PartTypeBase)) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part container at %s side %s does not have a valid part.", pos, pos.getSide()));
            return null;
        }
        PartTarget target = partType.getTarget(pos, partContainer.getPartState(pos.getSide()));
        return Triple.of((Object)partContainer, (Object)((PartTypeBase)partType), (Object)target);
    }

    public static PartTarget readPartTarget(FriendlyByteBuf packetBuffer) {
        return PartTarget.fromCenter((PartPos)PacketCodec.read((FriendlyByteBuf)packetBuffer, PartPos.class));
    }

    public static <P extends IPartType<P, S>, S extends IPartState<P>> P readPart(FriendlyByteBuf packetBuffer) {
        String name = packetBuffer.m_130277_();
        return (P)Objects.requireNonNull(PartTypeRegistry.getInstance().getPartType(new ResourceLocation(name)), String.format("Could not find a part by name %s", name));
    }

    public static class PartStateHolder<P extends IPartType<P, S>, S extends IPartState<P>> {
        private final IPartType<P, S> part;
        private final S state;

        public static PartStateHolder<?, ?> of(IPartType part, IPartState partState) {
            return new PartStateHolder(part, partState);
        }

        public PartStateHolder(IPartType<P, S> part, S state) {
            this.part = part;
            this.state = state;
        }

        public IPartType<P, S> getPart() {
            return this.part;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartStateHolder)) {
                return false;
            }
            PartStateHolder other = (PartStateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPartType<P, S> this$part = this.getPart();
            IPartType<P, S> other$part = other.getPart();
            if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
                return false;
            }
            S this$state = this.getState();
            S other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartStateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPartType<P, S> $part = this.getPart();
            result = result * 59 + ($part == null ? 43 : $part.hashCode());
            S $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "PartHelpers.PartStateHolder(part=" + String.valueOf(this.getPart()) + ", state=" + String.valueOf(this.getState()) + ")";
        }
    }

    public static interface IPartStateHolderCallback {
        public void onSet(PartStateHolder<?, ?> var1);
    }
}

