/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.setup.registry;

import com.github.jarva.allthearcanistgear.common.armor.ArcanistArmorSet;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import com.github.jarva.allthearcanistgear.setup.config.ServerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class AddonItemRegistry {
    public static final List<ArcanistArmorSet> ARMOR_SETS = new ArrayList<ArcanistArmorSet>();
    public static final List<RegistryObject<? extends Item>> REGISTERED_ITEMS = new ArrayList<RegistryObject<? extends Item>>();
    public static final List<RegistryObject<? extends Item>> DATAGEN_ITEMS = new ArrayList<RegistryObject<? extends Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"allthearcanistgear");
    public static final ArcanistArmorSet ALLTHEMODIUM = AddonItemRegistry.registerArmorSet(ServerConfig.ALLTHEMODIUM_CONFIG, 4);
    public static final ArcanistArmorSet VIBRANIUM = AddonItemRegistry.registerArmorSet(ServerConfig.VIBRANIUM_CONFIG, 5);
    public static final ArcanistArmorSet UNOBTAINIUM = AddonItemRegistry.registerArmorSet(ServerConfig.UNOBTAINIUM_CONFIG, 6);

    public static ArcanistArmorSet registerArmorSet(ArmorSetConfig config, int tier) {
        ArcanistArmorSet arcanistArmorSet = new ArcanistArmorSet(config, tier);
        ARMOR_SETS.add(arcanistArmorSet);
        return arcanistArmorSet;
    }

    public static RegistryObject<Item> register(String name, Supplier<Item> item) {
        return AddonItemRegistry.register(name, item, true);
    }

    public static RegistryObject<Item> register(String name, Supplier<Item> item, boolean dataGen) {
        RegistryObject registered = ITEMS.register(name, item);
        REGISTERED_ITEMS.add((RegistryObject<? extends Item>)registered);
        if (dataGen) {
            DATAGEN_ITEMS.add((RegistryObject<? extends Item>)registered);
        }
        return registered;
    }
}

