/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModTriggers;

public final class TBCapabilityDefault
implements ITBCapability {
    private int knowledge = 0;
    private int alignment = 0;
    private int alignmentLevel = 0;
    private final Map<Perk, Integer> perks = new ConcurrentHashMap<Perk, Integer>();
    private static final String KNOWLEDGE_NBT_INT = "knowledge";
    private static final String ALIGNMENT_NBT_SHORT = "alignment";

    @Override
    public int getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(int points) {
        this.knowledge = Math.max(0, points);
    }

    @Override
    public void rewardKnowledge(ServerPlayer player, int knowledge) {
        if (EntityHelper.isValidServerPlayer((Player)player) && knowledge > 0) {
            int newPerkPoints;
            int earnedPerkPoints;
            int oldPerkPoints = this.getTotalPerkPoints();
            this.knowledge += knowledge;
            if (PlayerPreference.get(player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_INCREASE_OF.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), knowledge});
            }
            if ((earnedPerkPoints = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                PacketHandler.sendToPlayer(new CMessageLevelUp(earnedPerkPoints), player);
                if (oldPerkPoints == 0) {
                    ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                }
                if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                    ModTriggers.MASTERY_1.trigger(player);
                }
                if (oldPerkPoints < 20 && newPerkPoints >= 20) {
                    ModTriggers.MASTERY_2.trigger(player);
                }
            }
            PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.KNOWLEDGE, this.knowledge), player);
        }
    }

    @Override
    public void rewardAlignment(ServerPlayer player, int alignment) {
        if (EntityHelper.isValidServerPlayer((Player)player) && alignment != 0) {
            if (PlayerPreference.get(player).displayAlignmentMessage()) {
                (alignment > 0 ? LangKey.MESSAGE_INCREASE_OF : LangKey.MESSAGE_DECREASE_OF).sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_ALIGNMENT.getText(new Object[0]), Math.abs(alignment)});
            }
            int oldAlignment = this.alignmentLevel;
            if (alignment > 0 && this.alignmentLevel < 0 || alignment < 0 && this.alignmentLevel > 0) {
                alignment *= 2;
            }
            this.setAlignment(this.alignment + alignment);
            PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALIGNMENT, this.alignment), player);
        }
    }

    @Override
    public void loseKnowledge(ServerPlayer player, int points) {
        if (EntityHelper.isValidServerPlayer((Player)player)) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (Player)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
            } else {
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.KNOWLEDGE, this.knowledge), player);
            }
            if (PlayerPreference.get(player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_DECREASE_OF.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
            }
        }
    }

    @Override
    public int getKnowledgeForLevel(int level) {
        return level <= 0 ? 0 : level * level + 1;
    }

    @Override
    public void setAlignment(int value) {
        this.alignment = Mth.m_14045_((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -5000;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 5000;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= this.getAlignmentMinValue()) {
            return -4;
        }
        if (this.alignment <= -3000) {
            return -3;
        }
        if (this.alignment <= -1500) {
            return -2;
        }
        if (this.alignment <= -500) {
            return -1;
        }
        if (this.alignment < 500) {
            return 0;
        }
        if (this.alignment < 1500) {
            return 1;
        }
        if (this.alignment < 3000) {
            return 2;
        }
        if (this.alignment < this.getAlignmentMaxValue()) {
            return 3;
        }
        return 4;
    }

    @Override
    public int getUsedPerkPoints(Player player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += entry.getKey().getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)Mth.m_14116_((float)(this.knowledge - 1));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public void setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
    }

    @Override
    public void removePerk(Perk perk) {
        this.perks.remove(perk);
    }

    @Override
    public int getPerkLevel(Player player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(Player player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public void resetPerks(ServerPlayer player) {
        this.setPerks(new HashMap<Perk, Integer>());
        EntityHelper.syncPlayerCapability(player);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KNOWLEDGE_NBT_INT, this.knowledge);
        nbt.m_128376_(ALIGNMENT_NBT_SHORT, (short)this.alignment);
        NBTStackHelper.writePerks(this.perks, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_(KNOWLEDGE_NBT_INT, 3)) {
            this.knowledge = nbt.m_128451_(KNOWLEDGE_NBT_INT);
        }
        if (nbt.m_128425_(ALIGNMENT_NBT_SHORT, 2)) {
            this.setAlignment(nbt.m_128448_(ALIGNMENT_NBT_SHORT));
        }
        NBTStackHelper.readPerks(this.perks, nbt);
    }
}

