/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class VerticalColumn
extends BaseMode {
    public VerticalColumn(boolean exchange) {
        super(exchange);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "vertical_column");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        ItemStack gadget = BaseGadget.getGadget(player);
        int range = GadgetNBT.getToolRange(gadget);
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        int halfRange = range / 2;
        if (hitSide.m_122434_().equals((Object)Direction.Axis.Y)) {
            if (this.isExchanging) {
                Direction playerFacing = player.m_6350_();
                for (int i = -halfRange; i <= halfRange; ++i) {
                    if (!this.isPosValid(player.m_9236_(), player, start.m_5484_(playerFacing, i), state)) continue;
                    coordinates.add(new StatePos(state, BlockPos.f_121853_.m_5484_(playerFacing, i)));
                }
            } else {
                for (int i = 1; i < range + 1; ++i) {
                    if (!this.isPosValid(player.m_9236_(), player, start.m_5484_(hitSide, i), state)) continue;
                    coordinates.add(new StatePos(state, BlockPos.f_121853_.m_5484_(hitSide, i)));
                }
            }
        } else {
            for (int i = -halfRange; i <= halfRange; ++i) {
                if (!this.isPosValid(player.m_9236_(), player, start.m_5484_(Direction.UP, i), state)) continue;
                coordinates.add(new StatePos(state, BlockPos.f_121853_.m_5484_(Direction.UP, i)));
            }
        }
        boolean connected = GadgetNBT.getSetting(gadget, GadgetNBT.NBTValues.CONNECTED_AREA.value);
        if (this.isExchanging && connected) {
            return this.removeUnConnected(player.m_9236_(), player, start.m_121996_((Vec3i)start), coordinates, hitSide);
        }
        return coordinates;
    }
}

