/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketSendCopyData;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendCopyDataToServer {
    private CompoundTag tag;

    public PacketSendCopyDataToServer(CompoundTag tag) {
        this.tag = tag;
    }

    public static PacketSendCopyDataToServer decode(FriendlyByteBuf buf) {
        return new PacketSendCopyDataToServer(buf.m_130260_());
    }

    public static void encode(PacketSendCopyDataToServer message, FriendlyByteBuf buf) {
        buf.m_130079_(message.tag);
    }

    public static void handle(PacketSendCopyDataToServer message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu container = sender.f_36096_;
            if (container == null || !(container instanceof TemplateManagerContainer)) {
                return;
            }
            ItemStack templateStack = container.m_38853_(1).m_7993_();
            if (templateStack.m_41619_()) {
                return;
            }
            if (templateStack.m_150930_(Items.f_42516_)) {
                container.m_182406_(1, container.m_182424_(), new ItemStack((ItemLike)Registration.Template.get()));
                templateStack = container.m_38853_(1).m_7993_();
            }
            BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(sender.m_9236_().m_7654_()).m_129783_());
            ArrayList<StatePos> buildList = BG2Data.statePosListFromNBTMapArray(message.tag);
            bg2Data.addToCopyPaste(GadgetNBT.getUUID(templateStack), buildList);
            GadgetNBT.setCopyUUID(templateStack);
            CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(GadgetNBT.getUUID(templateStack), false);
            PacketHandler.sendTo(new PacketSendCopyData(GadgetNBT.getUUID(templateStack), GadgetNBT.getCopyUUID(templateStack), tag), sender);
        });
        context.get().setPacketHandled(true);
    }
}

