/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class FuelTooltips {
    public static void makeTooltip(ZGatherTooltipComponents event) {
        int count;
        Screen screen;
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && (screen = Minecraft.m_91087_().f_91080_) != null && screen instanceof AbstractFurnaceScreen && (count = Quark.ZETA.itemExtensions.get(stack).getBurnTimeZeta(stack, RecipeType.f_44108_)) > 0) {
            Font font = Minecraft.m_91087_().f_91062_;
            String time = FuelTooltips.getDisplayString(count);
            event.getTooltipElements().add(Either.right((Object)new FuelComponent(stack, 18 + font.m_92895_(time), count)));
        }
    }

    private static String getDisplayString(int count) {
        float items = (float)count / (float)Math.max(1, ImprovedTooltipsModule.fuelTimeDivisor);
        String time = String.format(Locale.ROOT, items - (float)((int)items) == 0.0f ? "x%.0f" : "x%.1f", Float.valueOf(items));
        return time;
    }

    public record FuelComponent(ItemStack stack, int width, int count) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)tooltipX, (float)tooltipY, 500.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(ClientUtil.GENERAL_ICONS, 1, 1, 0.0f, 128.0f, 13, 13, 256, 256);
            String time = FuelTooltips.getDisplayString(this.count);
            guiGraphics.m_280056_(font, time, 16, 5, 16758272, true);
            pose.m_85849_();
        }

        public int m_142103_() {
            return 18;
        }

        public int m_142069_(@NotNull Font font) {
            return this.width;
        }
    }
}

