/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SortableTool;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ManasteelPickaxeItem
extends PickaxeItem
implements CustomDamageItem,
SortableTool {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final int MANA_PER_DAMAGE = 60;
    private static final int TIME = 5;

    public ManasteelPickaxeItem(Item.Properties props) {
        this(BotaniaAPI.instance().getManasteelItemTier(), props, -2.8f);
    }

    public ManasteelPickaxeItem(Tier mat, Item.Properties props, float attackSpeed) {
        super(mat, 1, attackSpeed, props);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int manaPerDamage = ((ManasteelPickaxeItem)stack.m_41720_()).getManaPerDamage();
        return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPerDamage);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player != null) {
            if (ctx.m_43724_() == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() instanceof BlockItem) {
                return InteractionResult.PASS;
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stackAt = player.m_150109_().m_8020_(i);
                if (stackAt.m_41619_() || !TORCH_PATTERN.matcher(stackAt.m_41720_().m_5524_()).find()) continue;
                ItemStack displayStack = stackAt.m_41777_();
                InteractionResult did = PlayerHelper.substituteUse(ctx, stackAt);
                if (!did.m_19077_()) continue;
                if (!ctx.m_43725_().f_46443_) {
                    ItemsRemainingRenderHandler.send(player, displayStack, TORCH_PATTERN);
                }
                player.m_36335_().m_41524_((Item)this, 5);
                return did;
            }
        }
        return InteractionResult.PASS;
    }

    public int getManaPerDamage() {
        return 60;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 120, true)) {
                stack.m_41721_(stack.m_41773_() - 1);
            }
        }
    }

    @Override
    public int getSortingPriority(ItemStack stack, BlockState state) {
        return ToolCommons.getToolPriority(stack);
    }
}

