/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.GrowingPlantBodyBlockMixin;
import vazkii.botania.xplat.BotaniaConfig;

public class AgricarnationBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int RANGE_MINI = 2;
    private static final int MANA_COST = 5;
    private static final float BONEMEAL_SUCCESS_CHANCE = 0.5f;

    protected AgricarnationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AgricarnationBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.AGRICARNATION, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.ticksExisted % 6 == 0 && this.redstoneSignal == 0) {
            int range = this.getRange();
            int x = this.getEffectivePos().m_123341_() + serverLevel.f_46441_.m_188503_(range * 2 + 1) - range;
            int z = this.getEffectivePos().m_123343_() + serverLevel.f_46441_.m_188503_(range * 2 + 1) - range;
            for (int i = 4; i > -2; --i) {
                BonemealableBlock bonemealableBlock;
                Optional<BlockPos> headPos;
                int y = this.getEffectivePos().m_123342_() + i;
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = serverLevel.m_8055_(pos);
                if (state.m_60795_()) continue;
                Block block = state.m_60734_();
                if (block instanceof GrowingPlantBodyBlock && (headPos = ((GrowingPlantBodyBlockMixin)block).botania_getHeadPos((BlockGetter)serverLevel, pos, block)).isPresent()) {
                    pos = headPos.get();
                }
                if (!this.isPlant((Level)serverLevel, pos, state, block) || this.getMana() <= 5) continue;
                this.addMana(-5);
                if (state.m_204336_(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL) && block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)serverLevel, pos, state, false)) {
                    if (serverLevel.f_46441_.m_188501_() < 0.5f && bonemealableBlock.m_214167_((Level)serverLevel, serverLevel.f_46441_, pos, state)) {
                        bonemealableBlock.m_214148_(serverLevel, serverLevel.f_46441_, pos, state);
                    }
                } else {
                    state.m_222972_(serverLevel, pos, serverLevel.f_46441_);
                }
                if (BotaniaConfig.common().blockBreakParticles()) {
                    serverLevel.m_46796_(2005, pos, 6 + serverLevel.f_46441_.m_188503_(4));
                }
                serverLevel.m_6263_(null, (double)x, (double)y, (double)z, BotaniaSounds.agricarnation, SoundSource.BLOCKS, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    private boolean isPlant(Level level, BlockPos pos, BlockState state, Block block) {
        BonemealableBlock bonemealableBlock;
        if (state.m_204336_(BotaniaTags.Blocks.AGRICARNATION_GROWTH_EXCLUDED) || (block instanceof SpreadingSnowyDirtBlock || block instanceof NyliumBlock) && !state.m_204336_(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE)) {
            return false;
        }
        boolean couldApplyBonemeal = block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, state, level.f_46443_);
        boolean isTargetCandidate = couldApplyBonemeal || block instanceof BushBlock || state.m_204336_(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE);
        boolean acceptsGrowthBoost = state.m_60823_() || couldApplyBonemeal && state.m_204336_(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL);
        return isTargetCandidate && acceptsGrowthBoost;
    }

    @Override
    public int getColor() {
        return 9369640;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    public int getRange() {
        return 5;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends AgricarnationBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.AGRICARNATION_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 2;
        }
    }
}

