/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ElvenTradeRecipeCategory
implements IRecipeCategory<ElvenTradeRecipe> {
    public static final RecipeType<ElvenTradeRecipe> TYPE = RecipeType.create((String)"botania", (String)"elven_trade", ElvenTradeRecipe.class);
    private final Component localizedName = Component.m_237115_((String)"botania.nei.elvenTrade");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public ElvenTradeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/elven_trade_overlay.png"), 0, 15, 140, 90);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BotaniaBlocks.alfPortal));
    }

    @NotNull
    public RecipeType<ElvenTradeRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull ElvenTradeRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        PoseStack matrices = gui.m_280168_();
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl"));
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer v = immediate.m_6299_(RenderType.m_110451_());
        int startX = 22;
        int startY = 25;
        int stopX = 70;
        int stopY = 73;
        Matrix4f mat = matrices.m_85850_().m_252922_();
        Matrix3f n = matrices.m_85850_().m_252943_();
        v.m_252986_(mat, (float)startX, (float)startY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        v.m_252986_(mat, (float)startX, (float)stopY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        v.m_252986_(mat, (float)stopX, (float)stopY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        v.m_252986_(mat, (float)stopX, (float)startY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        immediate.m_109911_();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ElvenTradeRecipe recipe, @NotNull IFocusGroup focusGroup) {
        int posX = 42;
        for (Ingredient ingr : recipe.m_7527_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, posX, 0).addIngredients(ingr);
            posX += 18;
        }
        int outIdx = 0;
        for (ItemStack stack : recipe.getOutputs()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 93 + outIdx % 2 * 20, 41 + outIdx / 2 * 20).addItemStack(stack);
            ++outIdx;
        }
    }
}

