/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.ritual.harvest.HarvestRegistry;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;

@RitualRegister(value="harvest")
public class RitualHarvest
extends Ritual {
    public static final String HARVEST_RANGE = "harvestRange";

    public RitualHarvest() {
        super("ritualHarvest", 0, 20000, "ritual.bloodmagic.harvestRitual");
        this.addBlockRange(HARVEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-4, 1, -4), 9, 5, 9));
        this.setMaximumVolumeAndDistanceOfRange(HARVEST_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        if (masterRitualStone.getOwnerNetwork().getCurrentEssence() < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int harvested = 0;
        AreaDescriptor harvestArea = masterRitualStone.getBlockRange(HARVEST_RANGE);
        harvestArea.resetIterator();
        while (harvestArea.hasNext()) {
            BlockPos nextPos = ((BlockPos)harvestArea.next()).m_121955_((Vec3i)pos);
            if (!RitualHarvest.harvestBlock(world, nextPos, masterRitualStone.getMasterBlockPos())) continue;
            ++harvested;
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * harvested));
    }

    @Override
    public int getRefreshCost() {
        return 20;
    }

    @Override
    public int getRefreshTime() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualHarvest();
    }

    public static boolean harvestBlock(Level world, BlockPos cropPos, BlockPos controllerPos) {
        BlockState harvestState = world.m_8055_(cropPos);
        BlockEntity potentialInventory = world.m_7702_(controllerPos.m_7494_());
        IItemHandler itemHandler = null;
        if (potentialInventory != null && potentialInventory.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).isPresent()) {
            itemHandler = (IItemHandler)potentialInventory.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).resolve().get();
        }
        for (IHarvestHandler handler : HarvestRegistry.getHarvestHandlers()) {
            ArrayList drops;
            if (!handler.test(world, cropPos, harvestState) || !handler.harvest(world, cropPos, harvestState, drops = Lists.newArrayList())) continue;
            for (ItemStack stack : drops) {
                if (stack.m_41619_()) continue;
                if (itemHandler != null) {
                    // empty if block
                }
                Containers.m_18992_((Level)world, (double)cropPos.m_123341_(), (double)cropPos.m_123342_(), (double)cropPos.m_123343_(), (ItemStack)stack);
            }
            return true;
        }
        return false;
    }
}

