/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;

public class LivingTrainerPacket {
    private int slot;
    private int ghostSlot;
    private int level;

    public LivingTrainerPacket() {
    }

    public LivingTrainerPacket(int slot, int ghostSlot, int level) {
        this.slot = slot;
        this.ghostSlot = ghostSlot;
        this.level = level;
    }

    public static void encode(LivingTrainerPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.ghostSlot);
        buf.writeInt(pkt.level);
    }

    public static LivingTrainerPacket decode(FriendlyByteBuf buf) {
        LivingTrainerPacket pkt = new LivingTrainerPacket(buf.readInt(), buf.readInt(), buf.readInt());
        return pkt;
    }

    public static void handle(LivingTrainerPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> LivingTrainerPacket.sendKeyToServer(message, (Player)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(LivingTrainerPacket msg, Player playerEntity) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.m_150109_().m_8020_(msg.slot);
        }
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof ItemLivingTrainer && msg.ghostSlot != -1) {
            ((ItemLivingTrainer)itemStack.m_41720_()).setTomeLevel(itemStack, msg.ghostSlot, msg.level);
        }
    }
}

