/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.registry;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.common.item.BloodOrb;

public class OrbRegistry {
    public static ArrayListMultimap<Integer, ItemStack> tierMap = ArrayListMultimap.create();
    private static List<BloodOrb> orbs = new ArrayList<BloodOrb>();

    public static List<ItemStack> getOrbsForTier(int tier) {
        if (OrbRegistry.getTierMap().containsKey((Object)tier)) {
            return OrbRegistry.getTierMap().get((Object)tier);
        }
        return Collections.emptyList();
    }

    public static List<ItemStack> getOrbsUpToTier(int tier) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 1; i <= tier; ++i) {
            ret.addAll(OrbRegistry.getOrbsForTier(i));
        }
        return ret;
    }

    public static List<ItemStack> getOrbsDownToTier(int tier) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = AltarTier.MAXTIERS; i >= tier; --i) {
            ret.addAll(OrbRegistry.getOrbsForTier(i));
        }
        return ret;
    }

    public static ItemStack getOrbStack(BloodOrb orb) {
        Item orbItem = (Item)ForgeRegistries.ITEMS.getValue(orb.getResourceLocation());
        if (orbItem == null) {
            return null;
        }
        return new ItemStack((ItemLike)orbItem);
    }

    public static ArrayListMultimap<Integer, ItemStack> getTierMap() {
        return ArrayListMultimap.create(tierMap);
    }
}

