/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.arc;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;

public class ARCRecipeCategory
implements IRecipeCategory<RecipeARC> {
    public static final RecipeType<RecipeARC> RECIPE_TYPE = RecipeType.create((String)"bloodmagic", (String)"arc", RecipeARC.class);
    public static final ResourceLocation BACKGROUNDRL = BloodMagic.rl("gui/jei/arc.png");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public ARCRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()));
        this.background = guiHelper.createDrawable(BACKGROUNDRL, 0, 0, 157, 43);
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.bloodmagic.recipe.arc");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull RecipeARC recipe, @Nonnull IFocusGroup focuses) {
        NonNullList<Ingredient> inputList = recipe.m_7527_();
        int inputSize = recipe.getRequiredInputCount();
        List<ItemStack> inputStackList = List.of(((Ingredient)inputList.get(0)).m_43908_());
        if (inputSize > 1) {
            for (ItemStack stack : inputStackList) {
                stack.m_41764_(inputSize);
            }
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputStackList)).setSlotName("input");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 22, 17).addIngredients((Ingredient)inputList.get(1))).setSlotName("tool");
        List<ItemStack> outputList = recipe.getAllListedOutputs();
        for (int i = 0; i < outputList.size(); ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 54 + i * 22, 17).addItemStack(outputList.get(i))).setSlotName("output");
        }
    }

    public RecipeType<RecipeARC> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void draw(RecipeARC recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        List<Pair<Double, Double>> chanceArray = recipe.getAllOutputChances();
        String[] infoString = new String[chanceArray.size()];
        for (int i = 0; i < infoString.length; ++i) {
            Pair<Double, Double> chance = chanceArray.get(i);
            double totalChance = (Double)chance.getLeft() + (Double)chance.getRight();
            infoString[i] = totalChance >= 1.0 ? "" : (totalChance < 0.01 ? "<1%" : (int)Math.round(totalChance * 100.0) + "%");
            guiGraphics.m_280056_(mc.f_91062_, infoString[i], 86 + 22 * i - mc.f_91062_.m_92895_(infoString[i]) / 2, 5, Color.white.getRGB(), true);
        }
        FluidStack outputStack = recipe.getFluidOutput();
        ClientHandler.handleGuiTank(guiGraphics, outputStack, outputStack.getAmount(), 140, 7, 16, 36, 157, 6, 18, 38, (int)mouseX, (int)mouseY, BACKGROUNDRL, null);
        if (recipe.getFluidIngredient() != null) {
            List inputFluids = recipe.getFluidIngredient().getRepresentations();
            FluidStack inputStack = (FluidStack)inputFluids.get(0);
            ClientHandler.handleGuiTank(guiGraphics, inputStack, inputStack.getAmount(), 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL, null);
        }
    }

    public List<Component> getTooltipStrings(RecipeARC recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        FluidStack outputStack = recipe.getFluidOutput();
        if (!outputStack.isEmpty()) {
            ClientHandler.handleGuiTank(null, outputStack, -1, 140, 8, 16, 34, 157, 7, 18, 36, (int)mouseX, (int)mouseY, BACKGROUNDRL, tooltip);
        }
        if (recipe.getFluidIngredient() != null) {
            List inputFluids = recipe.getFluidIngredient().getRepresentations();
            FluidStack inputStack = (FluidStack)inputFluids.get(0);
            ClientHandler.handleGuiTank(null, inputStack, -1, 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL, tooltip);
        }
        return tooltip;
    }
}

