/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei;

import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.screens.ScreenFilter;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.compat.jei.alchemytable.AlchemyTableRecipeCategory;
import wayoftime.bloodmagic.compat.jei.alchemytable.PotionRecipeCategory;
import wayoftime.bloodmagic.compat.jei.altar.BloodAltarRecipeCategory;
import wayoftime.bloodmagic.compat.jei.arc.ARCFurnaceRecipeCategory;
import wayoftime.bloodmagic.compat.jei.arc.ARCRecipeCategory;
import wayoftime.bloodmagic.compat.jei.array.AlchemyArrayCraftingCategory;
import wayoftime.bloodmagic.compat.jei.forge.TartaricForgeRecipeCategory;
import wayoftime.bloodmagic.compat.jei.ghostingredienthandlers.GhostFilter;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

@JeiPlugin
public class BloodMagicJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;
    private static final ResourceLocation ID;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.SOUL_FORGE.get()), new RecipeType[]{TartaricForgeRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.BLOOD_ALTAR.get()), new RecipeType[]{BloodAltarRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicItems.ARCANE_ASHES.get()), new RecipeType[]{AlchemyArrayCraftingCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()), new RecipeType[]{ARCRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()), new RecipeType[]{ARCFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()), new RecipeType[]{AlchemyTableRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()), new RecipeType[]{PotionRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelper = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new TartaricForgeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BloodAltarRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemyArrayCraftingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ARCRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ARCFurnaceRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemyTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PotionRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(TartaricForgeRecipeCategory.RECIPE_TYPE, BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForgeRecipes((Level)world));
        registration.addRecipes(BloodAltarRecipeCategory.RECIPE_TYPE, BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAltarRecipes((Level)world));
        registration.addRecipes(AlchemyArrayCraftingCategory.RECIPE_TYPE, BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyArrayRecipes((Level)world));
        registration.addRecipes(ARCRecipeCategory.RECIPE_TYPE, BloodMagicAPI.INSTANCE.getRecipeRegistrar().getARCRecipes((Level)world));
        registration.addRecipes(ARCFurnaceRecipeCategory.RECIPE_TYPE, world.m_7465_().m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44108_));
        registration.addRecipes(AlchemyTableRecipeCategory.RECIPE_TYPE, BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyTableRecipes((Level)world));
        registration.addRecipes(PotionRecipeCategory.RECIPE_TYPE, BloodMagicAPI.INSTANCE.getRecipeRegistrar().getPotionFlaskRecipes((Level)world));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(ScreenFilter.class, (IGhostIngredientHandler)new GhostFilter());
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    static {
        ID = BloodMagic.rl("jei_plugin");
    }
}

