/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.base.TileBase;

public class TileInversionPillar
extends TileBase
implements CommandSource {
    protected BlockPos teleportPos = BlockPos.f_121853_;
    protected ResourceKey<Level> destinationKey;

    public TileInversionPillar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileInversionPillar(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.INVERSION_PILLAR_TYPE.get(), pos, state);
    }

    public void setDestination(Level destinationWorld, BlockPos destinationPos) {
        this.destinationKey = destinationWorld.m_46472_();
        this.teleportPos = destinationPos;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        CompoundTag positionTag = tag.m_128469_("dungeon_teleport_pos");
        this.teleportPos = new BlockPos(positionTag.m_128451_("xCoord"), positionTag.m_128451_("yCoord"), positionTag.m_128451_("zCoord"));
        if (tag.m_128441_("dungeon_teleport_key")) {
            String key = tag.m_128461_("dungeon_teleport_key");
            this.destinationKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(key));
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        CompoundTag positionTag = new CompoundTag();
        positionTag.m_128405_("xCoord", this.teleportPos.m_123341_());
        positionTag.m_128405_("yCoord", this.teleportPos.m_123342_());
        positionTag.m_128405_("zCoord", this.teleportPos.m_123343_());
        tag.m_128365_("dungeon_teleport_pos", (Tag)positionTag);
        if (this.destinationKey != null) {
            tag.m_128359_("dungeon_teleport_key", this.destinationKey.m_135782_().toString());
        }
        return tag;
    }

    public void handlePlayerInteraction(Player player) {
        if (this.teleportPos.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        this.teleportPlayerToLocation((ServerLevel)this.f_58857_, player, this.destinationKey, this.teleportPos);
    }

    public CommandSourceStack getCommandSource(ServerLevel world) {
        return new CommandSourceStack((CommandSource)this, new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), Vec2.f_82462_, world, 2, "Inversion Pillar", (Component)Component.m_237113_((String)"Inversion Pillar"), world.m_7654_(), (Entity)null);
    }

    public void teleportPlayerToLocation(ServerLevel serverWorld, Player player, ResourceKey<Level> destination, BlockPos destinationPos) {
        String command = this.getTextCommandForTeleport(destination, player, (double)destinationPos.m_123341_() + 0.5, destinationPos.m_123342_(), (double)destinationPos.m_123343_() + 0.5);
        MinecraftServer mcServer = serverWorld.m_7654_();
        mcServer.m_129892_().m_230957_(this.getCommandSource(serverWorld), command);
    }

    public String getTextCommandForTeleport(ResourceKey<Level> destination, Player player, double posX, double posY, double posZ) {
        String playerName = player.m_7755_().getString();
        return "execute in " + destination.m_135782_().toString() + " run teleport " + playerName + " " + posX + " " + posY + " " + posZ;
    }

    public void m_213846_(Component component) {
    }

    public boolean m_6999_() {
        return false;
    }

    public boolean m_7028_() {
        return false;
    }

    public boolean m_6102_() {
        return false;
    }
}

