/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;
import wayoftime.bloodmagic.common.item.ArmorMaterialLiving;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ExpandedArmor;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class ItemLivingArmor
extends ArmorItem
implements ILivingContainer,
ExpandedArmor,
IForgeItem {
    private static final int MAX_ABSORPTION = 100000;

    public ItemLivingArmor(ArmorItem.Type type) {
        super(ArmorMaterialLiving.INSTANCE, type, new Item.Properties().m_41487_(1));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this == BloodMagicItems.LIVING_PLATE.get() || this == BloodMagicItems.LIVING_HELMET.get() || this == BloodMagicItems.LIVING_BOOTS.get()) {
            return "bloodmagic:models/armor/livingarmour_layer_1.png";
        }
        if (this == BloodMagicItems.LIVING_LEGGINGS.get()) {
            return "bloodmagic:models/armor/livingarmour_layer_2.png";
        }
        return null;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == BloodMagicItems.REAGENT_BINDING.get() || super.m_6832_(toRepair, repair);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (this != BloodMagicItems.LIVING_PLATE.get()) {
            return super.damageItem(stack, amount, entity, onBroken);
        }
        int durRemaining = stack.m_41776_() - 1 - stack.m_41773_();
        int value = Math.max(Math.min(durRemaining, amount), 0);
        return value;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(super.getAttributeModifiers(slot, stack));
        if (slot != EquipmentSlot.CHEST) {
            return modifiers;
        }
        if (this.getMaxDamage(stack) - this.getDamage(stack) <= 1) {
            return modifiers;
        }
        LivingStats stats = this.getLivingStats(stack);
        if (stats == null) {
            return modifiers;
        }
        stats.getUpgrades().forEach((arg_0, arg_1) -> ItemLivingArmor.lambda$getAttributeModifiers$0(stats, (Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @Override
    public void damageArmor(LivingEntity livingEntity, ItemStack stack, DamageSource source, float damage, EquipmentSlot slot) {
        if (slot == EquipmentSlot.CHEST && damage > (float)(this.m_41462_() - stack.m_41773_())) {
            livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 2.0f);
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        ILivingContainer.appendLivingTooltip(stack, this.getLivingStats(stack), tooltip, true);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.hasElytraUpgrade(stack, entity) && stack.m_41773_() < stack.m_41776_() - 1;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.m_9236_().f_46443_ && (flightTicks + 1) % 40 == 0) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
        }
        return true;
    }

    public boolean hasElytraUpgrade(ItemStack stack, LivingEntity entity) {
        if (stack.m_41720_() instanceof ItemLivingArmor && entity instanceof Player && LivingUtil.hasFullSet((Player)entity)) {
            return LivingStats.fromPlayer((Player)entity, true).getLevel(((LivingUpgrade)LivingArmorRegistrar.UPGRADE_ELYTRA.get()).getKey()) > 0;
        }
        return false;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        if (stack.m_41720_() instanceof ItemLivingArmor && wearer instanceof Player && LivingUtil.hasFullSet((Player)wearer)) {
            return LivingStats.fromPlayer((Player)wearer, true).getLevel(((LivingUpgrade)LivingArmorRegistrar.UPGRADE_GILDED.get()).getKey()) > 0;
        }
        return false;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(LivingStats stats, Multimap modifiers, LivingUpgrade k, Double v) {
        if (k.getAttributeProvider() != null) {
            k.getAttributeProvider().handleAttributes(stats, (Multimap<Attribute, AttributeModifier>)modifiers, UUID.nameUUIDFromBytes(k.getKey().toString().getBytes()), k, k.getLevel(v.intValue()));
        }
    }
}

