/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.proxy;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.thevortex.allthetweaks.AllTheTweaks;
import com.thevortex.allthetweaks.config.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class MyCons {
    private static InputStream iconStream(String prefix, String size) throws IOException {
        String location = String.format("textures/%s/icon_%s.png", prefix, size);
        return AllTheTweaks.proxy.getMinecraft().m_91098_().m_215595_(new ResourceLocation("allthetweaks", location));
    }

    public static void setWindowIcon() {
        if (System.getProperties().getProperty("os.name").contains("OS")) {
            return;
        }
        String prefix = switch ((Integer)Configuration.COMMON.mainmode.get()) {
            case 5 -> "icons_grav";
            case 3 -> "icons_magic";
            case 2 -> "icons_sky";
            case 1 -> "icons_slop";
            default -> "icons";
        };
        try (InputStream inputStream16 = MyCons.iconStream(prefix, "16x16");
             InputStream inputStream32 = MyCons.iconStream(prefix, "32x32");
             MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memoryStack.mallocInt(1);
            IntBuffer intbuffer1 = memoryStack.mallocInt(1);
            IntBuffer intbuffer2 = memoryStack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)2, (MemoryStack)memoryStack);
            ByteBuffer bytebuffer = MyCons.loadIco(inputStream16, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = MyCons.loadIco(inputStream32, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)AllTheTweaks.proxy.getMinecraft().m_91268_().m_85439_(), (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException e) {
            AllTheTweaks.LOGGER.error("Couldn't set icon", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ByteBuffer loadIco(InputStream p_198111_1_, IntBuffer p_198111_2_, IntBuffer p_198111_3_, IntBuffer p_198111_4_) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.assertInInitPhase();
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource((InputStream)p_198111_1_);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)p_198111_2_, (IntBuffer)p_198111_3_, (IntBuffer)p_198111_4_, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }
}

