/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.item;

import ad_astra_giselle_addon.common.config.ItemsConfig;
import ad_astra_giselle_addon.common.content.oxygen.ChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.item.ICreativeTabOutputProvider;
import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.util.NBTUtils;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public class OxygenCanItem
extends Item
implements BotariumFluidItem<WrappedItemFluidContainer>,
IOxygenChargerItem,
ICreativeTabOutputProvider {
    public static final String KEY_OXYGEN_CHARGER = "oxygencharger";
    public static final String KEY_CHARGE_MODE = "chargemode";

    public OxygenCanItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(this.getFluidCapacity(), 1, FluidPredicates::isOxygen));
    }

    protected long getFluidCapacity() {
        return FluidConstants.fromMillibuckets((long)ItemsConfig.OXYGEN_CAN_FLUID_CAPACITY);
    }

    protected long getFluidTransfer() {
        return FluidConstants.fromMillibuckets((long)ItemsConfig.OXYGEN_CAN_FLUID_TRANSFER);
    }

    @Override
    public void provideCreativeTabOutput(CreativeModeTab.Output output) {
        ItemStackHolder full = new ItemStackHolder(new ItemStack((ItemLike)this));
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(full);
        oxygenCharger.getFluidContainer().insertFluid(FluidHolder.of((Fluid)((Fluid)ModFluids.OXYGEN.get()), (long)oxygenCharger.getOxygenCapacity(), null), false);
        output.m_246342_(full.getStack());
    }

    public Rarity m_41460_(ItemStack item) {
        return this.m_5812_(item) ? Rarity.EPIC : super.m_41460_(item);
    }

    public boolean m_5812_(ItemStack item) {
        long totalAmount;
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(new ItemStackHolder(item));
        if (oxygenCharger != null && oxygenCharger.getChargeMode() != ChargeMode.NONE && (totalAmount = oxygenCharger.getOxygenAmount()) > 0L) {
            return true;
        }
        return super.m_5812_(item);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)item);
        }
        ItemStackReference holder = new ItemStackReference(item, ItemStackConsumers.hand(hand, (arg_0, arg_1) -> ((Player)player).m_21008_(arg_0, arg_1)));
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(holder);
        if (oxygenCharger != null && !player.m_6144_()) {
            IChargeMode chargeMode = oxygenCharger.getChargeMode();
            List<IChargeMode> modes = oxygenCharger.getAvailableChargeModes();
            int nextIndex = (modes.indexOf(chargeMode) + 1) % modes.size();
            IChargeMode nextMode = modes.get(nextIndex);
            oxygenCharger.setChargeMode(nextMode);
            player.m_213846_(TranslationUtils.descriptionChargeMode(nextMode));
        }
        return InteractionResultHolder.m_19098_((Object)item);
    }

    public void m_7373_(ItemStack item, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(item, level, tooltip, flag);
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(new ItemStackHolder(item));
        if (oxygenCharger != null) {
            tooltip.addAll(TranslationUtils.descriptionCanUse(oxygenCharger.canUseOnCold(), oxygenCharger.canUseOnHot()));
            tooltip.add(TranslationUtils.descriptionChargeMode(oxygenCharger.getChargeMode()));
            FluidContainer fluidContainer = oxygenCharger.getFluidContainer();
            List fluids = fluidContainer.getFluids();
            for (int i = 0; i < fluids.size(); ++i) {
                tooltip.add(TooltipUtils.getFluidComponent((FluidHolder)((FluidHolder)fluids.get(i)), (long)fluidContainer.getTankCapacity(i)));
            }
        }
    }

    public boolean m_142522_(ItemStack item) {
        return true;
    }

    public int m_142158_(ItemStack item) {
        double ratio = OxygenChargerUtils.get(new ItemStackHolder(item)).getOxygenStoredRatio();
        return (int)(ratio * 13.0);
    }

    public int m_142159_(ItemStack item) {
        double ratio = OxygenChargerUtils.get(new ItemStackHolder(item)).getOxygenStoredRatio();
        return Mth.m_14169_((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f);
    }

    @Override
    public IOxygenCharger getOxygenCharger(ItemStackHolder item) {
        return new AbstractOxygenCharger(item){

            @Override
            public boolean canUseOnCold() {
                return true;
            }

            @Override
            public boolean canUseOnHot() {
                return false;
            }
        };
    }

    public abstract class AbstractOxygenCharger
    implements IOxygenCharger {
        private final ItemStackHolder item;

        public AbstractOxygenCharger(ItemStackHolder item) {
            this.item = item;
        }

        @Override
        public void setChargeMode(IChargeMode mode) {
            CompoundTag tag = NBTUtils.getOrCreateTag(this.getItem().getStack(), OxygenCanItem.KEY_OXYGEN_CHARGER);
            tag.m_128365_(OxygenCanItem.KEY_CHARGE_MODE, IChargeMode.writeNBT(mode));
        }

        @Override
        public IChargeMode getChargeMode() {
            CompoundTag tag = NBTUtils.getTag(this.getItem().getStack(), OxygenCanItem.KEY_OXYGEN_CHARGER);
            return IChargeMode.readNBT(tag.m_128423_(OxygenCanItem.KEY_CHARGE_MODE));
        }

        @Override
        public long getTransferAmount() {
            return OxygenCanItem.this.getFluidTransfer();
        }

        @Override
        public FluidContainer getFluidContainer() {
            return FluidContainer.of((ItemStackHolder)this.getItem());
        }

        public final ItemStackHolder getItem() {
            return this.item;
        }
    }
}

