/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.overlay;

import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.screens.player.OverlayScreen;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class OxygenCanOverlay {
    public static final String OXYGENCAN_DESCRIPTION_ID = Util.m_137492_((String)"item", (ResourceLocation)AddonItems.OXYGEN_CAN.getId());

    public static void renderHud(GuiGraphics guiGraphics, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        if (minecraft.f_91066_.f_92063_) {
            return;
        }
        if (SpaceSuitItem.hasFullSet((LivingEntity)player) && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof SpaceSuitItem) {
            OxygenStorageUtils.getExtractableStoredRatio((LivingEntity)player).ifPresent(ratio -> {
                Font font = minecraft.f_91062_;
                MutableComponent component = Component.m_237115_((String)OXYGENCAN_DESCRIPTION_ID).m_130946_(": ").m_7220_((Component)Component.m_237119_().m_7220_(TranslationUtils.formatPercent(ratio)).m_130938_(s -> s.m_178520_(Mth.m_14169_((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f))));
                int textureWidth = 62;
                int textureHeight = 52;
                int width = font.m_92852_((FormattedText)component);
                int x = (int)((float)AdAstraConfigClient.oxygenBarX + (float)(textureWidth - width) / 2.0f);
                Objects.requireNonNull(font);
                int y = AdAstraConfigClient.oxygenBarY + textureHeight + 9 + 3;
                guiGraphics.m_280430_(font, (Component)component, Math.max(x, 0), y, 0xFFFFFF);
            });
        } else if (EnchantmentHelper.m_44836_((Enchantment)AddonEnchantments.OXYGEN_PROOF.get(), (LivingEntity)player) > 0) {
            OxygenStorageUtils.getExtractableStoredRatio((LivingEntity)player).ifPresent(ratio -> OxygenCanOverlay.renderOxygenCanTank(guiGraphics, minecraft, ratio));
        }
    }

    public static void renderOxygenCanTank(GuiGraphics graphics, Minecraft minecraft, double oxygenRatio) {
        int barHeight = (int)(oxygenRatio * 52.0);
        int x = AdAstraConfigClient.oxygenBarX;
        int y = AdAstraConfigClient.oxygenBarY;
        float scale = AdAstraConfigClient.oxygenBarScale;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        graphics.m_280163_(OverlayScreen.OXYGEN_TANK_EMPTY, x, y, 0.0f, 0.0f, 62, 52, 62, 52);
        graphics.m_280163_(OverlayScreen.OXYGEN_TANK, x, y + 52 - barHeight, 0.0f, (float)(52 - barHeight), 62, barHeight, 62, 52);
        Font font = minecraft.f_91062_;
        MutableComponent text = Component.m_237115_((String)OXYGENCAN_DESCRIPTION_ID).m_130946_(": ").m_7220_((Component)Component.m_237119_().m_7220_(TranslationUtils.formatPercent(oxygenRatio)).m_130938_(s -> s.m_178520_(Mth.m_14169_((float)((float)(oxygenRatio / 3.0)), (float)1.0f, (float)1.0f))));
        int textWidth = font.m_92852_((FormattedText)text);
        graphics.m_280430_(font, (Component)text, (int)((float)x + (float)(62 - textWidth) / 2.0f), y + 52 + 3, 0xFFFFFF);
        poseStack.m_85849_();
    }
}

