/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.projectile;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class DraconicArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;
    private static final EntityDataAccessor<Integer> SPECTRAL_TIME = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> TECH_LEVEL = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PENETRATION = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> GRAV_COMPENSATION = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> INIT_VELOCITY = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> PROJ_ANTI_IMMUNE = SynchedEntityData.m_135353_(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int blockPenetration = 0;

    public DraconicArrowEntity(EntityType<? extends DraconicArrowEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DraconicArrowEntity(Level world, double xPos, double yPos, double zPos) {
        super((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), xPos, yPos, zPos, world);
    }

    public DraconicArrowEntity(Level world, LivingEntity shooter) {
        super((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), shooter, world);
    }

    public void setSpectral(int spectralTime) {
        this.f_19804_.m_135381_(SPECTRAL_TIME, (Object)spectralTime);
    }

    public int getSpectralTime() {
        return (Integer)this.f_19804_.m_135370_(SPECTRAL_TIME);
    }

    public void setTechLevel(TechLevel techLevel) {
        this.f_19804_.m_135381_(TECH_LEVEL, (Object)((byte)techLevel.index));
    }

    public void setPenetration(float penetration) {
        int penCount = 0;
        while (penetration > this.f_19796_.m_188501_()) {
            ++penCount;
            penetration = (float)((double)penetration - 0.25);
        }
        this.f_19804_.m_135381_(PENETRATION, (Object)((byte)Math.min(penCount, 127)));
    }

    public void setProjectileImmuneOverride(boolean value) {
        this.f_19804_.m_135381_(PROJ_ANTI_IMMUNE, (Object)value);
    }

    public boolean getProjectileImmuneOverride() {
        return (Boolean)this.f_19804_.m_135370_(PROJ_ANTI_IMMUNE);
    }

    public void setGravComp(float gravComp) {
        this.f_19804_.m_135381_(GRAV_COMPENSATION, (Object)Float.valueOf(gravComp));
    }

    public void m_6686_(double p_70186_1_, double p_70186_3_, double p_70186_5_, float speed, float p_70186_8_) {
        super.m_6686_(p_70186_1_, p_70186_3_, p_70186_5_, speed, p_70186_8_);
        this.f_19804_.m_135381_(INIT_VELOCITY, (Object)Float.valueOf((float)this.m_20184_().m_82553_()));
    }

    public void m_37251_(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float speed, float p_234612_6_) {
        super.m_37251_(p_234612_1_, p_234612_2_, p_234612_3_, p_234612_4_, speed, p_234612_6_);
        this.f_19804_.m_135381_(INIT_VELOCITY, (Object)Float.valueOf((float)this.m_20184_().m_82553_()));
    }

    public void m_8119_() {
        this.superTick();
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void superTick() {
        VoxelShape voxelshape;
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
        boolean flag = this.m_36797_();
        Vec3 vector3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = vector3d.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            Vec3 vector3d1 = this.m_20182_();
            for (AABB axisalignedbb : voxelshape.m_83299_()) {
                if (!axisalignedbb.m_82338_(blockpos).m_82390_(vector3d1)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.f_36696_ != blockstate && this.m_36798_()) {
                this.m_36799_();
            } else if (!this.m_9236_().f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            this.f_36704_ = 0;
            Vec3 vector3d2 = this.m_20182_();
            Vec3 vector3d3 = vector3d2.m_82549_(vector3d);
            BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(vector3d2, vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                vector3d3 = raytraceresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityraytraceresult = this.m_6351_(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !flag) {
                    if (ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) break;
                    this.m_6532_((HitResult)raytraceresult);
                    this.f_19812_ = true;
                }
                if (entityraytraceresult == null || this.m_36796_() <= 0 && (Byte)this.f_19804_.m_135370_(PENETRATION) <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.m_20184_();
            double d3 = vector3d.f_82479_;
            double d4 = vector3d.f_82480_;
            double d0 = vector3d.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d3 * (double)i / 4.0, this.m_20186_() + d4 * (double)i / 4.0, this.m_20189_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.m_20185_() + d3;
            double d1 = this.m_20186_() + d4;
            double d2 = this.m_20189_() + d0;
            double f1 = vector3d.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d3), (double)(-d0)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875));
            this.m_146926_(DraconicArrowEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(DraconicArrowEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.m_6882_();
            }
            this.m_20256_(vector3d.m_82490_((double)f2));
            if (!this.m_20068_() && !flag) {
                Vec3 vector3d4 = this.m_20184_();
                float antiGrav = ((Float)this.f_19804_.m_135370_(GRAV_COMPENSATION)).floatValue();
                if (antiGrav > 0.0f && !this.f_36703_) {
                    float antiGravActivation = Math.min((float)this.m_20184_().m_82553_() / Math.max(((Float)this.f_19804_.m_135370_(INIT_VELOCITY)).floatValue() * 0.75f, 2.0f), 1.0f);
                    this.m_20334_(vector3d4.f_82479_, vector3d4.f_82480_ - (double)0.05f * (double)(1.0f - antiGravActivation * antiGrav), vector3d4.f_82481_);
                } else {
                    this.m_20334_(vector3d4.f_82479_, vector3d4.f_82480_ - (double)0.05f, vector3d4.f_82481_);
                }
            }
            this.m_6034_(d5, d1, d2);
            this.m_20101_();
        }
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Player player;
        Entity entity = p_213868_1_.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        byte penetration = (Byte)this.f_19804_.m_135370_(PENETRATION);
        if (this.m_36796_() > 0 || penetration > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1 && this.f_36701_.size() >= penetration + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity.m_19879_());
        }
        if (this.m_36792_()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        Entity owner = this.m_19749_();
        DamageSource damagesource = this.getDamageSource(entity);
        boolean isEnderman = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !isEnderman) {
            entity.m_20254_(5);
        }
        if (penetration > 1 && entity instanceof Player && (player = (Player)entity).m_6117_() && player.m_21211_().m_41720_() instanceof ShieldItem) {
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 100);
            this.m_9236_().m_7605_((Entity)player, (byte)30);
            player.m_5810_();
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_ && this.m_36796_() <= 0 && penetration <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.f_36699_ > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_36699_ * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
                if (owner != null && livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)owner).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(livingentity);
                }
                if (!this.m_9236_().f_46443_ && owner instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)owner;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, (Collection)this.f_36702_);
                    } else if (!entity.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0 && penetration <= 0) {
                this.m_146870_();
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(0.0));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    private DamageSource getDamageSource(Entity target) {
        Entity owner = this.m_19749_();
        TechLevel techLevel = TechLevel.byIndex((int)((Byte)this.f_19804_.m_135370_(TECH_LEVEL)).byteValue());
        boolean bypassImmune = this.getProjectileImmuneOverride() && DEConfig.projectileAntiImmuneEntities.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString());
        return DEDamage.draconicArrow(this.m_9236_(), (Entity)this, owner, techLevel, bypassImmune);
    }

    protected void m_8060_(BlockHitResult traceResult) {
        byte basePenetration = (Byte)this.f_19804_.m_135370_(PENETRATION);
        int remainingPenetration = basePenetration - this.blockPenetration;
        if (this.f_36701_ != null) {
            remainingPenetration -= this.f_36701_.size();
        }
        double canPenetrate = (double)remainingPenetration * 0.25;
        byte techLevel = (Byte)this.f_19804_.m_135370_(TECH_LEVEL);
        if (canPenetrate > 0.0 && (double)basePenetration >= (double)techLevel * 1.5) {
            VoxelShape voxelshape;
            this.blockPenetration += remainingPenetration;
            BlockPos pos = traceResult.m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (!blockstate.m_60795_() && !(voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), pos)).m_83281_()) {
                boolean canPass = true;
                Vec3 vector3d1 = traceResult.m_82450_().m_82549_(this.m_20184_().m_82541_().m_82542_(canPenetrate, canPenetrate, canPenetrate));
                for (AABB axisalignedbb : voxelshape.m_83299_()) {
                    if (!axisalignedbb.m_82338_(pos).m_82390_(vector3d1)) continue;
                    canPass = false;
                    break;
                }
                if (canPass) {
                    this.m_5496_(SoundEvents.f_12651_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                    for (int i = 0; i < 25; ++i) {
                        Vec3 critPos = traceResult.m_82450_().m_82549_(this.m_20184_().m_82541_().m_82542_(2.0, 2.0, 2.0).m_82520_((-0.5 + this.f_19796_.m_188583_()) * 0.2, (-0.5 + this.f_19796_.m_188583_()) * 0.2, (-0.5 + this.f_19796_.m_188583_()) * 0.2));
                        Vec3 critVel = this.m_20184_().m_82541_().m_82542_(5.0, 5.0, 5.0);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, critPos.f_82479_, critPos.f_82480_, critPos.f_82481_, critVel.f_82479_, critVel.f_82480_, critVel.f_82481_);
                    }
                    Vec3 shrapnelTravelEnd = traceResult.m_82450_().m_82549_(this.m_20184_().m_82541_().m_82542_((double)remainingPenetration, (double)remainingPenetration, (double)remainingPenetration));
                    EntityHitResult result = this.m_6351_(traceResult.m_82450_(), shrapnelTravelEnd);
                    if (result != null) {
                        Entity entity = result.m_82443_();
                        DamageSource damagesource = this.getDamageSource(entity);
                        float velocity = (float)this.m_20184_().m_82553_();
                        int damage = Mth.m_14165_((double)Mth.m_14008_((double)((double)velocity * this.m_36789_()), (double)0.0, (double)2.147483647E9));
                        entity.m_6469_(damagesource, (float)damage * 0.75f);
                    }
                }
            }
        }
        this.f_36696_ = this.m_9236_().m_8055_(traceResult.m_82425_());
        BlockState blockstate = this.m_9236_().m_8055_(traceResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, traceResult, (Projectile)this);
        Vec3 vector3d = traceResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36740_(SoundEvents.f_11685_);
        this.m_36793_(false);
        this.m_36723_();
    }

    public void setEffectsFromItem(ItemStack p_184555_1_) {
        if (p_184555_1_.m_41720_() == Items.f_42738_) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)p_184555_1_);
            List collection = PotionUtils.m_43571_((ItemStack)p_184555_1_);
            if (!collection.isEmpty()) {
                for (MobEffectInstance effectinstance : collection) {
                    this.effects.add(new MobEffectInstance(effectinstance));
                }
            }
            if ((i = DraconicArrowEntity.getCustomColor(p_184555_1_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_184555_1_.m_41720_() == Items.f_42412_) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_191508_0_) {
        CompoundTag compoundnbt = p_191508_0_.m_41783_();
        return compoundnbt != null && compoundnbt.m_128425_("CustomPotionColor", 99) ? compoundnbt.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_184558_1_) {
        this.effects.add(p_184558_1_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
        this.f_19804_.m_135372_(SPECTRAL_TIME, (Object)0);
        this.f_19804_.m_135372_(TECH_LEVEL, (Object)((byte)TechLevel.DRACONIUM.index));
        this.f_19804_.m_135372_(PENETRATION, (Object)0);
        this.f_19804_.m_135372_(GRAV_COMPENSATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(INIT_VELOCITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PROJ_ANTI_IMMUNE, (Object)false);
    }

    private void makeParticle(int p_184556_1_) {
        int i = this.getColor();
        if (i != -1 && p_184556_1_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_184556_1_; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)p_191507_1_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.potion != Potions.f_43598_ && this.potion != null) {
            compound.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
        if (this.getSpectralTime() > 0) {
            compound.m_128405_("spectral_time", ((Integer)this.f_19804_.m_135370_(SPECTRAL_TIME)).intValue());
        }
        compound.m_128344_("tech_level", ((Byte)this.f_19804_.m_135370_(TECH_LEVEL)).byteValue());
        compound.m_128344_("penetration", ((Byte)this.f_19804_.m_135370_(PENETRATION)).byteValue());
        compound.m_128350_("grav_comp", ((Float)this.f_19804_.m_135370_(GRAV_COMPENSATION)).floatValue());
        compound.m_128350_("init_velocity", ((Float)this.f_19804_.m_135370_(INIT_VELOCITY)).floatValue());
        compound.m_128379_("proj_anti_immune", ((Boolean)this.f_19804_.m_135370_(PROJ_ANTI_IMMUNE)).booleanValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        for (MobEffectInstance effectinstance : PotionUtils.m_43573_((CompoundTag)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.m_128425_("Color", 99)) {
            this.setFixedColor(compound.m_128451_("Color"));
        } else {
            this.updateColor();
        }
        if (compound.m_128441_("spectral_time")) {
            this.setSpectral(compound.m_128451_("spectral_time"));
        }
        if (compound.m_128441_("tech_level")) {
            this.f_19804_.m_135381_(TECH_LEVEL, (Object)compound.m_128445_("tech_level"));
        }
        if (compound.m_128441_("penetration")) {
            this.f_19804_.m_135381_(PENETRATION, (Object)compound.m_128445_("penetration"));
        }
        if (compound.m_128441_("grav_comp")) {
            this.f_19804_.m_135381_(GRAV_COMPENSATION, (Object)Float.valueOf(compound.m_128457_("grav_comp")));
        }
        if (compound.m_128441_("init_velocity")) {
            this.f_19804_.m_135381_(INIT_VELOCITY, (Object)Float.valueOf(compound.m_128457_("init_velocity")));
        }
        if (compound.m_128441_("proj_anti_immune")) {
            this.f_19804_.m_135381_(PROJ_ANTI_IMMUNE, (Object)compound.m_128471_("proj_anti_immune"));
        }
    }

    protected void m_7761_(LivingEntity p_184548_1_) {
        int spectralTime;
        super.m_7761_(p_184548_1_);
        for (MobEffectInstance effectinstance : this.potion.m_43488_()) {
            p_184548_1_.m_7292_(new MobEffectInstance(effectinstance.m_19544_(), Math.max(effectinstance.m_19557_() / 8, 1), effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effectinstance1 : this.effects) {
                p_184548_1_.m_7292_(effectinstance1);
            }
        }
        if ((spectralTime = ((Integer)this.f_19804_.m_135370_(SPECTRAL_TIME)).intValue()) > 0) {
            MobEffectInstance effectinstance;
            effectinstance = new MobEffectInstance(MobEffects.f_19619_, spectralTime, 0);
            p_184548_1_.m_7292_(effectinstance);
        }
    }

    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return (Packet)SneakyUtils.unsafeCast((Object)BCoreNetwork.getEntitySpawnPacket((Entity)this));
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268745_) || super.m_6673_(source);
    }
}

