/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.DelayedExecutor;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.lib.ExplosionHelper;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class ProcessExplosion
implements IProcess {
    public final Vector3 origin;
    private final ServerLevel level;
    private final MinecraftServer server;
    private final int minimumDelay;
    public double[] angularResistance;
    public boolean isDead = false;
    public int radius = 0;
    public int maxRadius;
    public double circumference = 0.0;
    public double meanResistance = 0.0;
    public boolean enableEffect = true;
    protected boolean calculationComplete = false;
    protected boolean detonated = false;
    protected long startTime = -1L;
    protected long calcWait = 0L;
    public boolean lava = true;
    public HashSet<Long> blocksToUpdate = new HashSet();
    public LinkedList<HashSet<Long>> destroyedBlocks = new LinkedList();
    public HashSet<Long> lavaPositions = new HashSet();
    public HashSet<Long> destroyedCache = new HashSet();
    public HashSet<Long> scannedCache = new HashSet();
    public BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
    public Consumer<Double> progressMon = null;
    private BlockState lavaState;

    public ProcessExplosion(BlockPos origin, int radius, ServerLevel world, int minimumDelayTime) {
        this.origin = Vector3.fromBlockPosCenter((BlockPos)origin);
        this.level = world;
        this.server = world.m_7654_();
        this.minimumDelay = minimumDelayTime;
        this.angularResistance = new double[121];
        Arrays.fill(this.angularResistance, 100.0);
        LogHelper.info("Explosion Calculation Started for " + radius + " Block radius detonation!");
        this.maxRadius = radius;
        this.lavaState = Blocks.f_49991_.m_49966_();
        if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation("cofhworld", "pyrotheum"))) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("cofhworld", "pyrotheum"));
        }
    }

    public void updateProcess() {
        this.server.f_129726_ = Util.m_137550_();
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.calcWait > 0L) {
            --this.calcWait;
            return;
        }
        if (!this.calculationComplete) {
            long t = System.currentTimeMillis();
            this.updateCalculation();
            t = System.currentTimeMillis() - t;
            this.calcWait = t / 40L;
            LogHelper.dev("Calculation Progress: " + MathUtils.round((double)((double)this.radius / (double)this.maxRadius * 100.0), (double)100.0) + "% " + Runtime.getRuntime().freeMemory() / 1000000L);
            if (this.calcWait > 0L) {
                LogHelper.dev("Explosion Calc loop took " + t + "ms! Waiting " + this.calcWait + " ticks before continuing");
            }
            if (this.progressMon != null) {
                this.progressMon.accept((double)this.radius / (double)this.maxRadius);
            }
        } else if (this.minimumDelay == -1) {
            this.isDead = true;
        } else if ((System.currentTimeMillis() - this.startTime) / 1000L >= (long)this.minimumDelay) {
            this.detonate();
        }
    }

    public void updateCalculation() {
        BlockPos originPos = this.origin.pos();
        double maxCoreHeight = 20.0 * ((double)this.maxRadius / 150.0);
        Vector3 posVecUp = new Vector3();
        Vector3 posVecDown = new Vector3();
        for (int x = originPos.m_123341_() - this.radius; x < originPos.m_123341_() + this.radius; ++x) {
            for (int z = originPos.m_123343_() - this.radius; z < originPos.m_123343_() + this.radius; ++z) {
                double dist = Utils.getDistance((double)x, (double)z, (double)originPos.m_123341_(), (double)originPos.m_123343_());
                if (!(dist < (double)this.radius) || !(dist >= (double)(this.radius - 1))) continue;
                posVecUp.set((double)x + 0.5, this.origin.y, (double)z + 0.5);
                double radialAngle = this.getRadialAngle(posVecUp);
                double radialResistance = this.getRadialResistance(radialAngle);
                double angularLoad = this.meanResistance / radialResistance * 1.0;
                double radialPos = 1.0 - (double)this.radius / (double)this.maxRadius;
                double coreFalloff = Math.max(0.0, (radialPos - 0.8) * 5.0);
                coreFalloff = 1.0 - (1.0 - coreFalloff) * (1.0 - coreFalloff) * (1.0 - coreFalloff);
                double coreHeight = coreFalloff * maxCoreHeight;
                double edgeNoise = Math.max(0.0, (-radialPos + 0.2) * 5.0);
                double edgeScatter = edgeNoise * (double)this.level.f_46441_.m_188503_(10);
                double sim = SimplexNoise.noise((double)((double)x / 50.0), (double)((double)z / 50.0));
                edgeNoise = 1.0 + Math.abs(sim) * edgeNoise * 8.0;
                double power = 10000.0 * radialPos * radialPos * radialPos * angularLoad * edgeNoise + edgeScatter;
                double heightUp = 20.0 + (5.0 + (double)this.radius / 10.0) * angularLoad;
                double heightDown = coreHeight + (5.0 + (double)this.radius / 10.0) * angularLoad * (1.0 - coreFalloff);
                posVecDown.set(posVecUp);
                double resist = this.trace(posVecUp, power, (int)(heightUp += Math.abs(sim) * 4.0 + this.level.f_46441_.m_188500_()) * 3, 1, 0.0, 0);
                resist += this.trace(posVecDown.subtract(0.0, 1.0, 0.0), power, (int)(heightDown += Math.abs(sim) * 4.0 + this.level.f_46441_.m_188500_()), -1, 0.0, 0);
                resist *= 1.0 / angularLoad;
                if (!(radialPos < 0.8)) continue;
                this.addRadialResistance(radialAngle, resist);
            }
        }
        this.recalcResist();
        ++this.radius;
        this.circumference = Math.PI * 2 * (double)this.radius;
        this.destroyedBlocks.add(this.destroyedCache);
        this.destroyedCache = new HashSet();
        this.scannedCache = new HashSet();
        if (this.radius >= this.maxRadius) {
            LogHelper.dev("Explosion Calculation Completed!");
            this.calculationComplete = true;
        }
    }

    private void recalcResist() {
        double total = 0.0;
        for (double resist : this.angularResistance) {
            total += resist;
        }
        this.meanResistance = total / (double)this.angularResistance.length;
    }

    public double getRadialAngle(Vector3 pos) {
        double theta = Math.atan2(pos.x - this.origin.x, this.origin.z - pos.z);
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        return theta / (Math.PI * 2) * (double)this.angularResistance.length;
    }

    public double getRadialResistance(double radialPos) {
        int max;
        int min = MathHelper.floor((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = MathHelper.ceil((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        return this.angularResistance[min] * (1.0 - delta) + this.angularResistance[max] * delta;
    }

    public void addRadialResistance(double radialPos, double power) {
        int max;
        int min = MathHelper.floor((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = MathHelper.ceil((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        int n = min;
        this.angularResistance[n] = this.angularResistance[n] + power * (1.0 - delta);
        int n2 = max;
        this.angularResistance[n2] = this.angularResistance[n2] + power * delta;
    }

    private double trace(Vector3 posVec, double power, int dist, int traceDir, double totalResist, int travel) {
        if (dist > 100) {
            dist = 100;
        }
        if (dist <= 0 || power <= 0.0 || posVec.y < (double)this.level.m_141937_() || posVec.y > (double)this.level.m_151558_()) {
            return totalResist;
        }
        --dist;
        ++travel;
        Long lPos = BlockPos.m_121882_((int)((int)posVec.x), (int)((int)posVec.y), (int)((int)posVec.z));
        if (this.scannedCache.contains(lPos) || this.destroyedCache.contains(lPos)) {
            posVec.add(0.0, (double)traceDir, 0.0);
            return this.trace(posVec, power, dist, traceDir, totalResist, travel);
        }
        this.mPos.m_122188_(lPos.longValue());
        double r = 1.0;
        BlockState state = this.level.m_8055_((BlockPos)this.mPos);
        Block block = state.m_60734_();
        if (!state.m_60795_()) {
            double effectivePower = power / 10.0 * ((double)dist / (double)(dist + travel));
            r = block.m_7325_();
            double removeResist = r;
            if (removeResist > 25.0 && removeResist < 1000000.0 && (double)dist < (double)this.maxRadius * 0.75) {
                removeResist = 25.0;
            }
            if (effectivePower >= removeResist) {
                this.destroyedCache.add(lPos);
            } else if (state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_)) {
                if (effectivePower > 5.0) {
                    this.destroyedCache.add(lPos);
                } else {
                    this.blocksToUpdate.add(lPos);
                }
                r = 10.0;
            } else {
                if (block instanceof IFluidBlock || block instanceof FallingBlock) {
                    this.blocksToUpdate.add(lPos);
                }
                this.scannedCache.add(lPos);
            }
            if (r > 1000.0) {
                r = 1000.0;
            }
        } else {
            this.scannedCache.add(lPos);
        }
        r = r / (double)this.radius / (double)travel;
        totalResist += r;
        power -= r;
        if (dist == 1 && traceDir == -1 && this.lava && this.level.f_46441_.m_188503_(250) == 0 && !this.level.m_46859_(this.mPos.m_7495_())) {
            dist = 0;
            this.destroyedCache.remove(lPos);
            this.lavaPositions.add(lPos);
            this.blocksToUpdate.add(lPos);
            this.scannedCache.add(lPos);
        }
        posVec.add(0.0, (double)traceDir, 0.0);
        return this.trace(posVec, power, dist, traceDir, totalResist, travel);
    }

    public boolean isCalculationComplete() {
        return this.calculationComplete;
    }

    public boolean detonate() {
        if (!this.isCalculationComplete() || this.detonated) {
            return false;
        }
        long l = System.currentTimeMillis();
        LogHelper.dev("Removing Blocks!");
        LogHelper.startTimer("Adding Blocks For Removal");
        ExplosionHelper removalHelper = new ExplosionHelper(this.level, this.origin.pos());
        int blocksRemoved = 0;
        removalHelper.setBlocksForRemoval(this.destroyedBlocks);
        LogHelper.stopTimer();
        LogHelper.startTimer("Adding update Blocks");
        removalHelper.addBlocksForUpdate(this.blocksToUpdate);
        LogHelper.dev("Blocks Removed: " + blocksRemoved);
        LogHelper.stopTimer();
        LogHelper.startTimer("Adding Lava");
        for (Long pos : this.lavaPositions) {
            this.level.m_46597_((BlockPos)this.mPos.m_122188_(pos.longValue()), this.lavaState);
        }
        LogHelper.stopTimer();
        removalHelper.finish();
        this.isDead = true;
        this.detonated = true;
        final BlockPos pos = this.origin.pos();
        if (this.enableEffect) {
            DraconicNetwork.sendExplosionEffect((ResourceKey<Level>)this.level.m_46472_(), pos, this.radius * 4, true);
        }
        for (int i = 0; i <= this.radius; i += 10) {
            final double calcRadius = (double)this.radius * ((double)i / (double)this.radius);
            new DelayedExecutor(i + 30, new Object[0]){

                public void execute(Object[] args) {
                    List list = ProcessExplosion.this.level.m_45976_(Entity.class, new AABB(pos, pos.m_7918_(1, 1, 1)).m_82377_(calcRadius * 2.5, calcRadius * 2.5, calcRadius * 2.5));
                    for (Entity e : list) {
                        double dist = Vec3D.getCenter((BlockPos)pos).distance(e);
                        float dmg = 1000.0f * (1.0f - (float)(dist / (calcRadius * 1.2)));
                        if (dmg <= 0.0f) continue;
                        e.m_6469_(DEDamage.fusionDamage((Level)ProcessExplosion.this.level), dmg);
                    }
                }
            }.run();
        }
        LogHelper.dev("Total explosion time: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "s");
        return true;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

