/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public interface IFusionRecipe
extends Recipe<IFusionInventory> {
    default public ItemStack m_8042_() {
        if (DraconicAPI.CRAFTING_CORE != null) {
            return new ItemStack((ItemLike)DraconicAPI.CRAFTING_CORE);
        }
        return new ItemStack((ItemLike)Blocks.f_50091_);
    }

    default public RecipeType<?> m_6671_() {
        return (RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get();
    }

    public TechLevel getRecipeTier();

    public long getEnergyCost();

    default public NonNullList<Ingredient> m_7527_() {
        return this.fusionIngredients().stream().map(IFusionIngredient::get).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    public List<IFusionIngredient> fusionIngredients();

    public Ingredient getCatalyst();

    default public boolean matches(IFusionInventory inv, Level level) {
        if (!this.getCatalyst().test(inv.getCatalystStack())) {
            return false;
        }
        ArrayList<IFusionInjector> injectors = new ArrayList<IFusionInjector>(inv.getInjectors());
        for (Ingredient ingredient : this.m_7527_()) {
            IFusionInjector match = injectors.stream().filter(e -> ingredient.test(e.getInjectorStack())).findFirst().orElse(null);
            if (match == null) {
                return false;
            }
            injectors.remove(match);
        }
        return injectors.stream().allMatch(e -> e.getInjectorStack().m_41619_());
    }

    default public void tickFusionState(IFusionStateMachine stateMachine, IFusionInventory inv, Level level) {
        switch (stateMachine.getFusionState()) {
            case START: {
                if (!this.matches(inv, level)) {
                    stateMachine.cancelCraft();
                    return;
                }
                long itemEnergy = this.getEnergyCost() / (long)this.fusionIngredients().size() + (long)inv.getInjectors().size();
                inv.getInjectors().stream().filter(e -> !e.getInjectorStack().m_41619_()).forEach(e -> e.setEnergyRequirement(itemEnergy, itemEnergy / (long)DEConfig.fusionChargeTime.get(e.getInjectorTier().index).intValue()));
                stateMachine.setFusionStatus(0.0, (Component)Component.m_237110_((String)"fusion_status.draconicevolution.charging", (Object[])new Object[]{0}).m_130940_(ChatFormatting.GREEN));
                stateMachine.setFusionState(IFusionStateMachine.FusionState.CHARGING);
                stateMachine.setCraftAnimation(0.0f, 0);
                break;
            }
            case CHARGING: {
                long totalCharge = inv.getInjectors().stream().mapToLong(IFusionInjector::getInjectorEnergy).sum();
                stateMachine.setFusionStatus((double)totalCharge / (double)this.getEnergyCost(), (Component)Component.m_237110_((String)"fusion_status.draconicevolution.charging", (Object[])new Object[]{(double)Math.round((double)totalCharge / (double)this.getEnergyCost() * 1000.0) / 10.0}).m_130940_(ChatFormatting.GREEN));
                if (totalCharge < this.getEnergyCost()) break;
                stateMachine.setFusionStatus(0.0, (Component)Component.m_237110_((String)"fusion_status.draconicevolution.crafting", (Object[])new Object[]{0}).m_130940_(ChatFormatting.GREEN));
                stateMachine.setCounter(0);
                int craftTime = DEConfig.fusionCraftTime.get(inv.getMinimumTier().index);
                stateMachine.setCraftAnimation(0.0f, craftTime);
                stateMachine.setFusionState(IFusionStateMachine.FusionState.CRAFTING);
                break;
            }
            case CRAFTING: {
                int craftTime = DEConfig.fusionCraftTime.get(inv.getMinimumTier().index);
                int counter = stateMachine.getCounter();
                stateMachine.setCraftAnimation((float)counter / (float)craftTime, craftTime);
                stateMachine.setCounter(counter + 1);
                stateMachine.setFusionStatus((double)counter / (double)craftTime, (Component)Component.m_237110_((String)"fusion_status.draconicevolution.crafting", (Object[])new Object[]{(double)Math.round((double)counter / (double)craftTime * 1000.0) / 10.0}).m_130940_(ChatFormatting.GREEN));
                if (counter < craftTime) break;
                if (inv.getInjectors().stream().anyMatch(e -> !e.validate())) {
                    stateMachine.cancelCraft();
                    return;
                }
                if (!this.matches(inv, level) || !this.canStartCraft(inv, level, null)) {
                    stateMachine.cancelCraft();
                    return;
                }
                IFusionRecipe.completeCraft(inv, level, this);
                stateMachine.completeCraft();
            }
        }
    }

    public static void completeCraft(IFusionInventory inv, Level level, IFusionRecipe recipe) {
        ArrayList<IFusionInjector> injectors = new ArrayList<IFusionInjector>(inv.getInjectors());
        block0: for (IFusionIngredient ingredient : recipe.fusionIngredients()) {
            for (IFusionInjector injector : injectors) {
                ItemStack stack = injector.getInjectorStack();
                if (stack.m_41619_() || !ingredient.get().test(stack) || injector.getInjectorTier().index < recipe.getRecipeTier().index) continue;
                if (!ingredient.consume()) continue block0;
                if (stack.hasCraftingRemainingItem()) {
                    stack = stack.m_41720_().getCraftingRemainingItem(stack);
                } else {
                    stack.m_41774_(1);
                }
                injector.setInjectorStack(stack);
                injector.setInjectorEnergy(0L);
                injectors.remove(injector);
                continue block0;
            }
        }
        int catCount = 1;
        if (recipe.getCatalyst() instanceof IngredientStack) {
            catCount = ((IngredientStack)recipe.getCatalyst()).getCount();
        }
        ItemStack catalyst = inv.getCatalystStack();
        ItemStack result = recipe.m_5874_(inv, level.m_9598_());
        catalyst.m_41774_(catCount);
        inv.setCatalystStack(catalyst);
        ItemStack outputStack = inv.getOutputStack();
        if (outputStack.m_41619_()) {
            inv.setOutputStack(result.m_41777_());
        } else {
            outputStack.m_41769_(result.m_41613_());
        }
    }

    default public boolean canStartCraft(IFusionInventory inv, Level level, @Nullable Consumer<Component> userStatus) {
        ItemStack result;
        ItemStack output = inv.getOutputStack();
        if (!(output.m_41619_() || ItemStack.m_150942_((ItemStack)output, (ItemStack)(result = this.m_5874_(inv, level.m_9598_()))) && output.m_41613_() + result.m_41613_() <= result.m_41720_().getMaxStackSize(result))) {
            if (userStatus != null) {
                userStatus.accept((Component)Component.m_237115_((String)"fusion_status.draconicevolution.output_obstructed").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (inv.getMinimumTier().index < this.getRecipeTier().index) {
            if (userStatus != null) {
                userStatus.accept((Component)Component.m_237115_((String)"fusion_status.draconicevolution.tier_low").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (userStatus != null) {
            userStatus.accept((Component)Component.m_237115_((String)"fusion_status.draconicevolution.ready").m_130940_(ChatFormatting.GREEN));
        }
        return true;
    }

    default public boolean m_8004_(int width, int height) {
        return true;
    }

    default public boolean m_5598_() {
        return true;
    }

    public static interface IFusionIngredient {
        public Ingredient get();

        public boolean consume();
    }
}

