/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionFilter {
    private static WildcardedRLMatcher dimensionMatcherB = null;
    private static WildcardedRLMatcher dimensionMatcherW = null;

    public static boolean isDimensionOK(ResourceKey<Level> levelKey) {
        ResourceLocation name = levelKey.m_135782_();
        return !DimensionFilter.getDimensionBlacklist().test(name) && (DimensionFilter.getDimensionWhitelist().isEmpty() || DimensionFilter.getDimensionWhitelist().test(name));
    }

    private static WildcardedRLMatcher getDimensionWhitelist() {
        if (dimensionMatcherW == null) {
            dimensionMatcherW = new WildcardedRLMatcher((Collection)FTBEConfig.RTP_DIMENSION_WHITELIST.get());
        }
        return dimensionMatcherW;
    }

    private static WildcardedRLMatcher getDimensionBlacklist() {
        if (dimensionMatcherB == null) {
            dimensionMatcherB = new WildcardedRLMatcher((Collection)FTBEConfig.RTP_DIMENSION_BLACKLIST.get());
        }
        return dimensionMatcherB;
    }

    public static void clearMatcherCaches() {
        dimensionMatcherB = null;
        dimensionMatcherW = null;
    }

    private static class WildcardedRLMatcher
    implements Predicate<ResourceLocation> {
        private final Set<String> namespaces = new ObjectOpenHashSet();
        private final Set<ResourceLocation> reslocs = new ObjectOpenHashSet();

        public WildcardedRLMatcher(Collection<String> toMatch) {
            for (String s : toMatch) {
                if (s.endsWith(":*")) {
                    this.namespaces.add(s.split(":")[0]);
                    continue;
                }
                if (!ResourceLocation.m_135830_((String)s)) continue;
                this.reslocs.add(new ResourceLocation(s));
            }
        }

        public boolean isEmpty() {
            return this.reslocs.isEmpty() && this.namespaces.isEmpty();
        }

        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.reslocs.contains(resourceLocation) || this.namespaces.contains(resourceLocation.m_135827_());
        }
    }
}

