/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.inventory.slot.chemical.PigmentInventorySlot;
import mekanism.common.inventory.slot.chemical.SlurryInventorySlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedChemicalInventorySlot<MERGED extends MergedChemicalTank>
extends BasicInventorySlot {
    protected final MERGED mergedTank;

    private static boolean hasCapability(@NotNull ItemStack stack) {
        return stack.getCapability(Capabilities.GAS_HANDLER).isPresent() || stack.getCapability(Capabilities.INFUSION_HANDLER).isPresent() || stack.getCapability(Capabilities.PIGMENT_HANDLER).isPresent() || stack.getCapability(Capabilities.SLURRY_HANDLER).isPresent();
    }

    public static MergedChemicalInventorySlot<MergedChemicalTank> drain(MergedChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Merged chemical tank cannot be null");
        Predicate<@NotNull ItemStack> gasInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> infusionInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> slurryInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> insertPredicate = (stack, automationType) -> switch (chemicalTank.getCurrent()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedChemicalTank.Current.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.EMPTY -> gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        };
        return new MergedChemicalInventorySlot<MergedChemicalTank>(chemicalTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, MergedChemicalInventorySlot::hasCapability, listener, x, y);
    }

    public static MergedChemicalInventorySlot<MergedChemicalTank> fill(MergedChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Merged chemical tank cannot be null");
        Predicate<@NotNull ItemStack> gasExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> infusionExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> pigmentExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> slurryExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        Predicate<@NotNull ItemStack> gasInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getGasTank(), GasInventorySlot.getCapability(stack));
        Predicate<@NotNull ItemStack> infusionInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getInfusionTank(), InfusionInventorySlot.getCapability(stack));
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getPigmentTank(), PigmentInventorySlot.getCapability(stack));
        Predicate<@NotNull ItemStack> slurryInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getSlurryTank(), SlurryInventorySlot.getCapability(stack));
        return new MergedChemicalInventorySlot<MergedChemicalTank>(chemicalTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            return switch (chemicalTank.getCurrent()) {
                default -> throw new IncompatibleClassChangeError();
                case MergedChemicalTank.Current.GAS -> gasExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.INFUSION -> infusionExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.PIGMENT -> pigmentExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.SLURRY -> slurryExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.EMPTY -> gasExtractPredicate.test((ItemStack)stack) && infusionExtractPredicate.test((ItemStack)stack) && pigmentExtractPredicate.test((ItemStack)stack) && slurryExtractPredicate.test((ItemStack)stack);
            };
        }, (stack, automationType) -> switch (chemicalTank.getCurrent()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedChemicalTank.Current.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.EMPTY -> gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        }, MergedChemicalInventorySlot::hasCapability, listener, x, y);
    }

    protected MergedChemicalInventorySlot(MERGED mergedTank, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.mergedTank = mergedTank;
    }

    public void drainChemicalTanks() {
        this.drainChemicalTank(MergedTank.CurrentType.GAS);
        this.drainChemicalTank(MergedTank.CurrentType.INFUSION);
        this.drainChemicalTank(MergedTank.CurrentType.PIGMENT);
        this.drainChemicalTank(MergedTank.CurrentType.SLURRY);
    }

    public void drainChemicalTank(MergedTank.CurrentType type) {
        if (type == MergedTank.CurrentType.GAS) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getGasTank(), GasInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.INFUSION) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getInfusionTank(), InfusionInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.PIGMENT) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getPigmentTank(), PigmentInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.SLURRY) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getSlurryTank(), SlurryInventorySlot.getCapability(this.current));
        }
    }

    public void fillChemicalTanks() {
        this.fillChemicalTank(MergedTank.CurrentType.GAS);
        this.fillChemicalTank(MergedTank.CurrentType.INFUSION);
        this.fillChemicalTank(MergedTank.CurrentType.PIGMENT);
        this.fillChemicalTank(MergedTank.CurrentType.SLURRY);
    }

    public void fillChemicalTank(MergedTank.CurrentType type) {
        if (type == MergedTank.CurrentType.GAS) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getGasTank(), GasInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.INFUSION) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getInfusionTank(), InfusionInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.PIGMENT) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getPigmentTank(), PigmentInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.SLURRY) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getSlurryTank(), SlurryInventorySlot.getCapability(this.current));
        }
    }
}

