/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraftforge.items.IItemHandler;

public class Extruder2ModuleMenu
extends ModuleMenu {
    private static final int TEMPLATE_SLOTS = 9;

    Extruder2ModuleMenu(int windowId, Inventory inv, FriendlyByteBuf extra) {
        this(windowId, inv, MFLocator.fromBuffer(extra));
    }

    public Extruder2ModuleMenu(int windowId, Inventory inv, MFLocator locator) {
        super((MenuType)ModMenuTypes.EXTRUDER2_MENU.get(), windowId, inv, locator);
        TemplateHandler handler = new TemplateHandler(locator.getModuleStack(inv.f_35978_), this.router);
        for (int i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new FilterSlot((IItemHandler)handler, i, 129 + 18 * (i % 3), 17 + 18 * (i / 3)));
        }
    }

    @Override
    protected void transferStackInExtraSlot(Player player, int index) {
        ((Slot)this.f_38839_.get(index)).m_5852_(ItemStack.f_41583_);
    }

    @Override
    protected void slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, Player player) {
        Slot s = (Slot)this.f_38839_.get(slot);
        ItemStack stackOnCursor = this.m_142621_();
        ItemStack stackInSlot = s.m_7993_().m_41777_();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            s.m_5852_(ItemStack.f_41583_);
        } else if (!stackOnCursor.m_41619_() && !ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)stackOnCursor) && s.m_5857_(stackOnCursor)) {
            ItemStack stack1 = stackOnCursor.m_41777_();
            if (dragType == 1) {
                stack1.m_41764_(1);
            }
            s.m_5852_(stack1);
        } else if (!stackInSlot.m_41619_()) {
            if (dragType == 1) {
                stackInSlot.m_41764_(Math.min(stackInSlot.m_41741_(), stackInSlot.m_41613_() + 1));
            } else if (dragType == 0) {
                stackInSlot.m_41774_(1);
            }
            s.m_5852_(stackInSlot);
            s.m_6654_();
        }
    }

    private static boolean isItemOKForTemplate(ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            Block b = bi.m_40614_();
            return b.m_49966_().m_60799_() == RenderShape.MODEL && !MiscUtil.getRegistryName(b).orElseThrow().m_135827_().equals("chiselsandbits");
        }
        return true;
    }

    public static class TemplateHandler
    extends BaseModuleHandler {
        private static final String NBT_TEMPLATE = "Template";

        public TemplateHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
            super(holderStack, router, 9, NBT_TEMPLATE);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return Extruder2ModuleMenu.isItemOKForTemplate(stack);
        }
    }
}

