/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;

public class FloatTextField
extends TextFieldWidgetMR {
    private final float min;
    private final float max;
    private float incr = 1.0f;
    private float fine = 0.1f;
    private float coarse = 5.0f;
    private String precStr = "%.1f";

    public FloatTextField(TextFieldManager parent, Font fontrendererObj, int x, int y, int par5Width, int par6Height, float min, float max) {
        super(parent, fontrendererObj, x, y, par5Width, par6Height);
        this.min = min;
        this.max = max;
        this.m_94199_(5);
        this.m_94153_(input -> {
            if (input == null || input.isEmpty() || input.equals("-")) {
                return true;
            }
            try {
                float f = Float.parseFloat(input);
                return f >= this.min && f <= this.max;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public void setIncr(float incr, float fine, float coarse) {
        this.incr = incr;
        this.fine = fine;
        this.coarse = coarse;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return switch (keyCode) {
            case 265 -> this.adjustField(this.incr);
            case 264 -> this.adjustField(-this.incr);
            case 266 -> this.adjustField(this.max);
            case 267 -> this.adjustField(-this.max);
            default -> super.m_7933_(keyCode, scanCode, modifiers);
        };
    }

    @Override
    public void onMouseWheel(int direction) {
        this.adjustField(direction > 0 ? this.incr : -this.incr);
    }

    public void setValue(float newVal) {
        if (newVal >= this.min && newVal <= this.max) {
            this.m_94144_(String.format(this.precStr, Float.valueOf(newVal)));
        }
    }

    public void setPrecision(int precision) {
        this.precStr = "%." + precision + "f";
    }

    private boolean adjustField(float adj) {
        float val;
        if (Screen.m_96637_()) {
            adj *= this.fine;
        } else if (Screen.m_96638_()) {
            adj *= this.coarse;
        }
        try {
            val = Float.parseFloat(this.m_94155_());
        }
        catch (NumberFormatException e) {
            val = this.min;
        }
        float newVal = Math.max(this.min, Math.min(this.max, val + adj));
        if (newVal != val) {
            this.m_94144_("");
            this.m_94164_(String.format(this.precStr, Float.valueOf(newVal)));
        }
        return true;
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.m_94155_());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }
}

