/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.Side;
import appeng.core.localization.Tooltips;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import com.glodblock.github.extendedae.api.IPage;
import com.glodblock.github.extendedae.client.ExSemantics;
import com.glodblock.github.extendedae.common.tileentities.TileExInscriber;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ContainerExInscriber
extends UpgradeableMenu<TileExInscriber>
implements IProgressProvider,
IPage,
IActionHolder {
    public static final MenuType<ContainerExInscriber> TYPE = MenuTypeBuilder.create(ContainerExInscriber::new, TileExInscriber.class).build("ex_inscriber");
    private final Slot[] tops = new Slot[4];
    private final Slot[] middles = new Slot[4];
    private final Slot[] bottoms = new Slot[4];
    private final Slot[] outputs = new Slot[4];
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    private static final SlotSemantic[] TOP = new SlotSemantic[]{SlotSemantics.INSCRIBER_PLATE_TOP, ExSemantics.EX_1, ExSemantics.EX_2, ExSemantics.EX_3};
    private static final SlotSemantic[] BOTTOM = new SlotSemantic[]{SlotSemantics.INSCRIBER_PLATE_BOTTOM, ExSemantics.EX_4, ExSemantics.EX_5, ExSemantics.EX_6};
    private static final SlotSemantic[] MIDDLE = new SlotSemantic[]{SlotSemantics.MACHINE_INPUT, ExSemantics.EX_7, ExSemantics.EX_8, ExSemantics.EX_9};
    private static final SlotSemantic[] OUTPUT = new SlotSemantic[]{SlotSemantics.MACHINE_OUTPUT, ExSemantics.EX_10, ExSemantics.EX_11, ExSemantics.EX_12};
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;
    @GuiSync(value=7)
    public YesNo separateSides = YesNo.NO;
    @GuiSync(value=8)
    public YesNo autoExport = YesNo.NO;
    @GuiSync(value=9)
    public int page = 0;

    public ContainerExInscriber(int id, Inventory ip, TileExInscriber host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.actions.put("show", o -> this.showPage());
        this.actions.put("stack", o -> ((TileExInscriber)this.getHost()).setInvStackSize((Integer)o.get(0)));
        for (int x = 0; x < 4; ++x) {
            InternalInventory inv = host.getIndexInventory(x);
            AppEngSlot top = new AppEngSlot(inv, 0);
            top.setIcon(Icon.BACKGROUND_PLATE);
            top.setEmptyTooltip(() -> this.separateSides == YesNo.YES ? Tooltips.inputSlot((Side[])new Side[]{Side.TOP}) : Tooltips.inputSlot((Side[])new Side[]{Side.ANY}));
            this.tops[x] = this.addSlot((Slot)top, TOP[x]);
            AppEngSlot bottom = new AppEngSlot(inv, 1);
            bottom.setIcon(Icon.BACKGROUND_PLATE);
            bottom.setEmptyTooltip(() -> this.separateSides == YesNo.YES ? Tooltips.inputSlot((Side[])new Side[]{Side.BOTTOM}) : Tooltips.inputSlot((Side[])new Side[]{Side.ANY}));
            this.bottoms[x] = this.addSlot((Slot)bottom, BOTTOM[x]);
            AppEngSlot middle = new AppEngSlot(inv, 2);
            middle.setIcon(Icon.BACKGROUND_INGOT);
            middle.setEmptyTooltip(() -> this.separateSides == YesNo.YES ? Tooltips.inputSlot((Side[])new Side[]{Side.LEFT, Side.RIGHT, Side.BACK, Side.FRONT}) : Tooltips.inputSlot((Side[])new Side[]{Side.ANY}));
            this.middles[x] = this.addSlot((Slot)middle, MIDDLE[x]);
            OutputSlot output = new OutputSlot(inv, 3, null);
            output.setEmptyTooltip(() -> this.separateSides == YesNo.YES ? Tooltips.outputSlot((Side[])new Side[]{Side.LEFT, Side.RIGHT, Side.BACK, Side.FRONT}) : Tooltips.outputSlot((Side[])new Side[]{Side.ANY}));
            this.outputs[x] = this.addSlot((Slot)output, OUTPUT[x]);
        }
    }

    public void showPage() {
        for (int x = 0; x < 4; ++x) {
            ((AppEngSlot)this.tops[x]).setSlotEnabled(x == this.page);
            ((AppEngSlot)this.bottoms[x]).setSlotEnabled(x == this.page);
            ((AppEngSlot)this.middles[x]).setSlotEnabled(x == this.page);
            ((AppEngSlot)this.outputs[x]).setSlotEnabled(x == this.page);
        }
        ((TileExInscriber)this.getHost()).markForUpdate();
    }

    public int getStackMode() {
        return ((TileExInscriber)this.getHost()).getInvStackSize() == 1 ? 0 : 1;
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.separateSides = (YesNo)((TileExInscriber)this.getHost()).getConfigManager().getSetting(Settings.INSCRIBER_SEPARATE_SIDES);
        this.autoExport = (YesNo)((TileExInscriber)this.getHost()).getConfigManager().getSetting(Settings.AUTO_EXPORT);
    }

    protected void standardDetectAndSendChanges() {
        if (this.isServerSide()) {
            this.maxProcessingTime = ((TileExInscriber)this.getHost()).getMaxProcessingTime();
            this.processingTime = ((TileExInscriber)this.getHost()).getProcessingTime(this.page);
        }
        super.standardDetectAndSendChanges();
    }

    public boolean isValidForSlot(Slot s, ItemStack is) {
        ItemStack top = ((TileExInscriber)this.getHost()).getInternalInventory().getStackInSlot(0);
        ItemStack bot = ((TileExInscriber)this.getHost()).getInternalInventory().getStackInSlot(1);
        if (s == this.middles[this.page]) {
            ItemDefinition press = AEItems.NAME_PRESS;
            if (press.isSameAs(top) || press.isSameAs(bot)) {
                return !press.isSameAs(is);
            }
            return InscriberRecipes.findRecipe((Level)((TileExInscriber)this.getHost()).m_58904_(), (ItemStack)is, (ItemStack)top, (ItemStack)bot, (boolean)false) != null;
        }
        if (s == this.tops[this.page] && !bot.m_41619_() || s == this.bottoms[this.page] && !top.m_41619_()) {
            ItemDefinition namePress = AEItems.NAME_PRESS;
            ItemStack otherSlot = s == this.tops[this.page] ? this.bottoms[this.page].m_7993_() : this.tops[this.page].m_7993_();
            if (namePress.isSameAs(otherSlot)) {
                return namePress.isSameAs(is);
            }
            return InscriberRecipes.isValidOptionalIngredientCombination((Level)Objects.requireNonNull(((TileExInscriber)this.getHost()).m_58904_()), (ItemStack)is, (ItemStack)otherSlot);
        }
        return true;
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return this.maxProcessingTime;
    }

    public YesNo getSeparateSides() {
        return this.separateSides;
    }

    public YesNo getAutoExport() {
        return this.autoExport;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }
}

