/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui.subgui;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.me.common.ClientDisplaySlot;
import appeng.client.gui.widgets.NumberEntryWidget;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import com.google.common.primitives.Longs;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SetAmount<C extends AEBaseMenu, P extends AEBaseScreen<C>>
extends AESubScreen<C, P> {
    private final NumberEntryWidget amount;
    private final GenericStack currentStack;
    private final Consumer<GenericStack> setter;
    private final boolean checkSize;

    public SetAmount(P parentScreen, ItemStack icon, GenericStack currentStack, Consumer<GenericStack> setter) {
        this(parentScreen, icon, currentStack, setter, true);
    }

    public SetAmount(P parentScreen, ItemStack icon, GenericStack currentStack, Consumer<GenericStack> setter, boolean checkSize) {
        super(parentScreen, "/screens/set_precise_bus_amount.json");
        this.checkSize = checkSize;
        this.currentStack = currentStack;
        this.setter = setter;
        this.widgets.addButton("save", (Component)GuiText.Set.text(), this::confirm);
        TabButton button = new TabButton(icon, icon.m_41786_(), btn -> this.returnToParent());
        this.widgets.add("back", (AbstractWidget)button);
        this.amount = this.widgets.addNumberEntryWidget("amountToStock", NumberEntryType.of((AEKey)currentStack.what()));
        this.amount.setLongValue(currentStack.amount());
        if (this.checkSize) {
            this.amount.setMaxValue(this.getMaxAmount());
        }
        this.amount.setTextFieldStyle(this.style.getWidget("amountToStockInput"));
        this.amount.setMinValue(0L);
        this.amount.setHideValidationIcon(true);
        this.amount.setOnConfirm(this::confirm);
        this.addClientSideSlot((Slot)new ClientDisplaySlot(currentStack), SlotSemantics.MACHINE_OUTPUT);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setSlotsHidden(SlotSemantics.TOOLBOX, true);
    }

    private void confirm() {
        this.amount.getLongValue().ifPresent(newAmount -> {
            newAmount = this.checkSize ? Longs.constrainToRange((long)newAmount, (long)0L, (long)this.getMaxAmount()) : Math.max(newAmount, 0L);
            if (newAmount <= 0L) {
                this.setter.accept(null);
            } else {
                this.setter.accept(new GenericStack(this.currentStack.what(), newAmount));
            }
            this.returnToParent();
        });
    }

    private long getMaxAmount() {
        return 64L * (long)this.currentStack.what().getAmountPerUnit();
    }
}

