/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringRepresentable;

public enum ModelTier implements StringRepresentable
{
    FAULTY("faulty", 0, 1, ChatFormatting.DARK_GRAY, 0.01f),
    BASIC("basic", 6, 4, ChatFormatting.GREEN, 0.05f),
    ADVANCED("advanced", 54, 10, ChatFormatting.BLUE, 0.22f),
    SUPERIOR("superior", 354, 18, ChatFormatting.LIGHT_PURPLE, 0.65f),
    SELF_AWARE("self_aware", 1254, 0, ChatFormatting.GOLD, 0.995f);

    private static final ModelTier[] VALUES;
    public final String name;
    private TierData tierData;
    public static final Codec<ModelTier> CODEC;

    private ModelTier(String name, int requiredData, int dataPerKill, ChatFormatting color, float accuracy) {
        this(name, requiredData, dataPerKill, TextColor.m_131270_((ChatFormatting)color), accuracy);
    }

    private ModelTier(String name, int requiredData, int dataPerKill, TextColor color, float accuracy) {
        this.name = name;
        this.tierData = new TierData(requiredData, dataPerKill, color, accuracy);
    }

    public ModelTier previous() {
        if (this == FAULTY) {
            return this;
        }
        return VALUES[this.ordinal() - 1];
    }

    public ModelTier next() {
        if (this == SELF_AWARE) {
            return this;
        }
        return VALUES[this.ordinal() + 1];
    }

    public Component getComponent() {
        return Component.m_237115_((String)("hostilenetworks.tier." + this.name)).m_130948_(Style.f_131099_.m_131148_(this.data().color));
    }

    public static ModelTier getByData(DynamicHolder<DataModel> model, int data) {
        return !model.isBound() ? FAULTY : ModelTier.getByData((DataModel)model.get(), data);
    }

    public static ModelTier getByData(DataModel model, int data) {
        for (int i = 4; i >= 0; --i) {
            if (data < model.getTierData(VALUES[i])) continue;
            return VALUES[i];
        }
        return FAULTY;
    }

    public static int[] defaultData() {
        return Arrays.stream(VALUES).mapToInt(t -> t.data().requiredData).toArray();
    }

    public static int[] defaultDataPerKill() {
        return Arrays.stream(VALUES).mapToInt(t -> t.data().dataPerKill).toArray();
    }

    public String m_7912_() {
        return this.name;
    }

    public TierData data() {
        return this.tierData;
    }

    public int color() {
        return this.data().color.m_131265_();
    }

    public float accuracy() {
        return this.data().accuracy;
    }

    void updateData(TierData data) {
        this.tierData = data;
    }

    static {
        VALUES = ModelTier.values();
        CODEC = StringRepresentable.m_216439_(() -> VALUES);
    }

    public record TierData(int requiredData, int dataPerKill, TextColor color, float accuracy) implements CodecProvider<TierData>
    {
        public static final Codec<TierData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("required_data").forGetter(TierData::requiredData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("data_per_kill").forGetter(TierData::dataPerKill), (App)TextColor.f_237295_.fieldOf("color").forGetter(TierData::color), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("accuracy").forGetter(TierData::accuracy)).apply((Applicative)inst, TierData::new));

        public Codec<? extends TierData> getCodec() {
            return CODEC;
        }
    }
}

